/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Node;
import polyglot.ast.StringLit;
import polyglot.ext.jl.ast.Lit_c;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class StringLit_c
extends Lit_c
implements StringLit {
    protected String value;
    protected int MAX_LENGTH = 60;

    public StringLit_c(Position pos, String value) {
        super(pos);
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public StringLit value(String value) {
        StringLit_c n = (StringLit_c)this.copy();
        n.value = value;
        return n;
    }

    public Object objValue() {
        return this.value;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        return this.type(tc.typeSystem().String());
    }

    public String toString() {
        if (StringUtil.unicodeEscape(this.value).length() > 11) {
            return "\"" + StringUtil.unicodeEscape(this.value.substring(0, 8)) + "...\"";
        }
        return "\"" + StringUtil.unicodeEscape(this.value) + "\"";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        String s;
        List l = this.breakupString();
        if (l.size() > 1) {
            w.write("(");
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            s = (String)i.next();
            w.begin(0);
        }
        i = l.iterator();
        while (i.hasNext()) {
            s = (String)i.next();
            w.write("\"");
            w.write(StringUtil.escape(s));
            w.write("\"");
            w.end();
            if (!i.hasNext()) continue;
            w.write(" +");
            w.allowBreak(0, " ");
        }
        if (l.size() > 1) {
            w.write(")");
        }
    }

    protected List breakupString() {
        LinkedList<String> result = new LinkedList<String>();
        int n = this.value.length();
        int i = 0;
        while (i < n) {
            char c;
            int k;
            int j;
            int len = 0;
            for (j = i; j < n && len + (k = StringUtil.unicodeEscape(c = this.value.charAt(j)).length()) <= this.MAX_LENGTH; ++j) {
                len += k;
            }
            result.add(this.value.substring(i, j));
            i = j;
        }
        if (result.isEmpty()) {
            if (!this.value.equals("")) {
                throw new InternalCompilerError("breakupString failed");
            }
            result.add(this.value);
        }
        return result;
    }

    public boolean isConstant() {
        return true;
    }

    public Object constantValue() {
        return this.value;
    }
}

