/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import polyglot.ast.CanonicalTypeNode;
import polyglot.ext.jl.ast.TypeNode_c;
import polyglot.main.Options;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;

public class CanonicalTypeNode_c
extends TypeNode_c
implements CanonicalTypeNode {
    public CanonicalTypeNode_c(Position pos, Type type) {
        super(pos);
        this.type = type;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.type == null) {
            w.write("<unknown-type>");
        } else {
            w.write(((Object)this.type).toString());
        }
    }

    public void translate(CodeWriter w, Translator tr) {
        TypeSystem ts = tr.typeSystem();
        if (tr.outerClass() != null) {
            w.write(this.type.translate(ts.classContextResolver(tr.outerClass())));
        } else if (this.type.isClass() && this.type.toClass().isMember()) {
            w.write(this.type.translate(null));
        } else if (!Options.global.fully_qualified_names) {
            w.write(this.type.translate(tr.context()));
        } else {
            w.write(this.type.translate(null));
        }
    }

    public String toString() {
        if (this.type == null) {
            return "<unknown-type>";
        }
        return ((Object)this.type).toString();
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(type " + this.type + ")");
        w.end();
    }
}

