/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.processing.AbstractProcessingFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLizingProcessingFilter
extends AbstractProcessingFilter {
    private static final Comparator<SootClass> CLASS_COMPARATOR = new LexographicalClassComparator();
    private static final Comparator<SootField> FIELD_COMPARATOR = new LexographicalFieldComparator();
    private static final Comparator<SootMethod> METHOD_COMPARATOR = new LexographicalMethodComparator();

    @Override
    protected Collection<SootClass> localFilterClasses(Collection<SootClass> classes) {
        ArrayList<SootClass> _result = new ArrayList<SootClass>(classes);
        Collections.sort(_result, CLASS_COMPARATOR);
        return _result;
    }

    @Override
    protected Collection<SootField> localFilterFields(Collection<SootField> fields) {
        ArrayList<SootField> _result = new ArrayList<SootField>(fields);
        Collections.sort(_result, FIELD_COMPARATOR);
        return _result;
    }

    @Override
    protected Collection<SootMethod> localFilterMethods(Collection<SootMethod> methods) {
        ArrayList<SootMethod> _result = new ArrayList<SootMethod>(methods);
        Collections.sort(_result, METHOD_COMPARATOR);
        return _result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LexographicalClassComparator
    implements Comparator<SootClass> {
        @Override
        public int compare(SootClass o1, SootClass o2) {
            SootClass _sc1 = o1;
            SootClass _sc2 = o2;
            return _sc1.getName().compareTo(_sc2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LexographicalFieldComparator
    implements Comparator<SootField> {
        @Override
        public int compare(SootField o1, SootField o2) {
            String _sig1 = o1.getSignature();
            String _sig2 = o2.getSignature();
            return _sig1.compareTo(_sig2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LexographicalMethodComparator
    implements Comparator<SootMethod> {
        @Override
        public int compare(SootMethod o1, SootMethod o2) {
            String _sig1 = o1.getSignature();
            String _sig2 = o2.getSignature();
            return _sig1.compareTo(_sig2);
        }
    }
}

