/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.ValueBox;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UniqueJimpleIDGenerator
implements IJimpleIDGenerator {
    private final Map<SootClass, List<SootField>> class2fields = new HashMap<SootClass, List<SootField>>();
    private final Map<SootClass, List<SootMethod>> class2methods = new HashMap<SootClass, List<SootMethod>>();
    private List<SootClass> classes = new ArrayList<SootClass>();
    private final Map<SootMethod, List<Local>> method2locals = new HashMap<SootMethod, List<Local>>();

    private static <T> List<T> sort(Collection<T> collection) {
        ArrayList<T> _result = new ArrayList<T>(collection);
        Collections.sort(_result, ToStringBasedComparator.getComparator());
        return _result;
    }

    @Override
    public String getIdForClass(SootClass clazz) {
        if (!this.classes.contains(clazz)) {
            this.classes.add(clazz);
        }
        return "c" + String.valueOf(this.classes.indexOf(clazz));
    }

    @Override
    public String getIdForField(SootField field) {
        SootClass _declClass = field.getDeclaringClass();
        if (!this.class2fields.containsKey(_declClass)) {
            ArrayList _f = new ArrayList(_declClass.getFields());
            this.class2fields.put(_declClass, UniqueJimpleIDGenerator.sort(_f));
        }
        List<SootField> _fields = this.class2fields.get(_declClass);
        return String.valueOf(this.getIdForClass(_declClass)) + "_f" + _fields.indexOf(field);
    }

    @Override
    public String getIdForLocal(Local v, SootMethod method) {
        if (!this.method2locals.containsKey(method)) {
            ArrayList _l = new ArrayList(method.getActiveBody().getLocals());
            this.method2locals.put(method, UniqueJimpleIDGenerator.sort(_l));
        }
        List<Local> _locals = this.method2locals.get(method);
        return String.valueOf(this.getIdForMethod(method)) + "_l" + _locals.indexOf(v);
    }

    @Override
    public String getIdForMethod(SootMethod method) {
        SootClass _declClass = method.getDeclaringClass();
        if (!this.class2methods.containsKey(_declClass)) {
            ArrayList _c = new ArrayList(_declClass.getMethods());
            this.class2methods.put(_declClass, UniqueJimpleIDGenerator.sort(_c));
        }
        List<SootMethod> _methods = this.class2methods.get(_declClass);
        return String.valueOf(this.getIdForClass(method.getDeclaringClass())) + "_m" + _methods.indexOf(method);
    }

    @Override
    public String getIdForStmt(Stmt stmt, SootMethod method) {
        String _result = "?";
        if (method.isConcrete()) {
            PatchingChain _c = method.getActiveBody().getUnits();
            int _count = 0;
            Iterator _i = _c.iterator();
            while (_i.hasNext()) {
                if (stmt == _i.next()) break;
                ++_count;
            }
            _result = String.valueOf(_count);
        }
        return String.valueOf(this.getIdForMethod(method)) + "_s" + _result;
    }

    @Override
    public String getIdForType(Type type) {
        String _result;
        if (type instanceof RefType) {
            _result = this.getIdForClass(((RefType)type).getSootClass());
        } else if (type instanceof ArrayType) {
            ArrayType _arrayType = (ArrayType)type;
            StringBuffer _t = new StringBuffer(this.getIdForType(_arrayType.baseType));
            _t.append(".." + _arrayType.numDimensions);
            _result = _t.toString();
        } else {
            _result = type.toString().replaceAll("[\\[\\]]", "_.").replaceAll("\\p{Blank}", "");
        }
        return _result;
    }

    @Override
    public String getIdForValueBox(ValueBox box, Stmt stmt, SootMethod method) {
        List _vBoxes = stmt.getUseAndDefBoxes();
        return String.valueOf(this.getIdForStmt(stmt, method)) + "_v" + _vBoxes.indexOf(box);
    }

    @Override
    public void reset() {
        this.method2locals.clear();
        this.class2fields.clear();
        this.class2methods.clear();
        this.classes.clear();
    }
}

