/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.NamedTag;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Environment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.JimpleXMLizer;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.File;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootClass;
import soot.tagkit.Tag;

public final class JimpleXMLizerCLI {
    private static final Logger LOGGER = LoggerFactory.getLogger(JimpleXMLizerCLI.class);

    @Empty
    private JimpleXMLizerCLI() {
    }

    public static void main(String[] s) {
        Scene _scene = Scene.v();
        Options _options = new Options();
        Option _o = new Option("d", "dump directory", true, "The directory in which to write the xml files.  If unspecified, the xml output will be directed standard out.");
        _o.setArgs(1);
        _o.setArgName("path");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        _o = new Option("h", "help", false, "Display message.");
        _options.addOption(_o);
        _o = new Option("p", "soot-classpath", true, "Prepend this to soot class path.");
        _o.setArgs(1);
        _o.setArgName("classpath");
        _o.setOptionalArg(false);
        _options.addOption(_o);
        HelpFormatter _help = new HelpFormatter();
        try {
            CommandLine _cl = new BasicParser().parse(_options, s);
            String[] _args = _cl.getArgs();
            if (_cl.hasOption('h')) {
                String _cmdLineSyn = "java " + JimpleXMLizerCLI.class.getName() + "<options> <class names>";
                _help.printHelp(_cmdLineSyn.length(), _cmdLineSyn, "", _options, "", true);
            } else if (_args.length > 0) {
                if (_cl.hasOption('p')) {
                    _scene.setSootClassPath(String.valueOf(_cl.getOptionValue('p')) + File.pathSeparator + _scene.getSootClassPath());
                }
                NamedTag _tag = new NamedTag("JimpleXMLizer");
                int _i = 0;
                while (_i < _args.length) {
                    SootClass _sc = _scene.loadClassAndSupport(_args[_i]);
                    _sc.addTag((Tag)_tag);
                    ++_i;
                }
                TagBasedProcessingFilter _filter = new TagBasedProcessingFilter(_tag.getName());
                JimpleXMLizerCLI.writeJimpleAsXML(new Environment(_scene), _cl.getOptionValue('d'), null, new UniqueJimpleIDGenerator(), _filter);
            } else {
                System.out.println("No classes were specified.");
            }
        }
        catch (ParseException _e) {
            LOGGER.error("Error while parsing command line.", (Throwable)_e);
            JimpleXMLizerCLI.printUsage(_options);
        }
        catch (Throwable _e) {
            LOGGER.error("Beyond our control. May day! May day!", _e);
            throw new RuntimeException(_e);
        }
    }

    public static void writeJimpleAsXML(IEnvironment env, String directory, String suffix, IJimpleIDGenerator jimpleIDGenerator, IProcessingFilter processingFilter) {
        JimpleXMLizer _xmlizer = new JimpleXMLizer(jimpleIDGenerator);
        ProcessingController _pc = new ProcessingController();
        CompleteStmtGraphFactory _sgf = new CompleteStmtGraphFactory();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(_sgf);
        _pc.setStmtSequencesRetriever(_ssr);
        _pc.setEnvironment(env);
        XMLizingProcessingFilter _xmlFilter = new XMLizingProcessingFilter();
        if (processingFilter != null) {
            _xmlFilter.chain(processingFilter);
        }
        _pc.setProcessingFilter(_xmlFilter);
        _xmlizer.setDumpOptions(directory, suffix);
        _xmlizer.hookup(_pc);
        _pc.process();
        _xmlizer.unhook(_pc);
    }

    private static void printUsage(Options options) {
        String _cmdLineSyn = "java " + JimpleXMLizerCLI.class.getName() + " <options> <classnames>";
        new HelpFormatter().printHelp(_cmdLineSyn, "Options are: ", options, "");
    }
}

