/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.CustomXMLOutputter;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.JimpleStmtXMLizer;
import edu.ksu.cis.indus.xmlizer.JimpleValueXMLizer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.znerd.xmlenc.XMLOutputter;
import soot.Body;
import soot.Local;
import soot.Modifier;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.jimple.Stmt;
import soot.util.Chain;

public class JimpleXMLizer
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JimpleXMLizer.class);
    private String currType;
    private String dumpDirectory;
    private String fileSuffix;
    private final IJimpleIDGenerator idGenerator;
    private boolean processingClass;
    private boolean processingMethod;
    private final JimpleStmtXMLizer stmtXmlizer;
    private XMLOutputter writer;

    public JimpleXMLizer(IJimpleIDGenerator generator) {
        this.idGenerator = generator;
        this.stmtXmlizer = new JimpleStmtXMLizer(new JimpleValueXMLizer(generator), generator);
    }

    public final void callback(SootClass clazz) {
        try {
            if (this.processingClass) {
                this.writer.endDocument();
            } else {
                this.processingClass = true;
            }
            String _classId = this.setupFile(clazz);
            this.currType = clazz.isInterface() ? "interface" : "class";
            this.writer.startTag(this.currType);
            this.writer.attribute("name", clazz.getJavaStyleName());
            this.writer.attribute("id", _classId);
            this.writer.attribute("package", clazz.getJavaPackageName());
            this.writer.attribute("abstract", String.valueOf(clazz.isAbstract()));
            this.writer.attribute("accessSpec", this.getAccessSpecifier(clazz.getModifiers()));
            if (clazz.hasSuperclass()) {
                SootClass _sc = clazz.getSuperclass();
                this.writer.startTag("superclass");
                this.writer.attribute("typeId", this.idGenerator.getIdForClass(_sc));
                this.writer.endTag();
            }
            if (clazz.getInterfaceCount() > 0) {
                this.writer.startTag("interfaceList");
                for (SootClass _inter : clazz.getInterfaces()) {
                    this.writer.startTag("superinterface");
                    this.writer.attribute("typeId", this.idGenerator.getIdForClass(_inter));
                    this.writer.endTag();
                }
                this.writer.endTag();
            }
            this.processingMethod = false;
        }
        catch (IOException _e) {
            LOGGER.warn("Error while writing xmlized jimple info.", (Throwable)_e);
        }
    }

    public final void callback(SootField field) {
        block7: {
            try {
                this.writer.startTag("field");
                this.writer.attribute("name", field.getName());
                this.writer.attribute("id", this.idGenerator.getIdForField(field));
                this.writer.attribute("typeId", this.idGenerator.getIdForType(field.getType()));
                this.writer.attribute("static", String.valueOf(field.isStatic()));
                this.writer.attribute("final", String.valueOf(field.isFinal()));
                String _accessSpec = "";
                if (field.isPublic()) {
                    _accessSpec = "public";
                } else if (field.isPrivate()) {
                    _accessSpec = "private";
                } else if (field.isProtected()) {
                    _accessSpec = "proctected";
                }
                this.writer.attribute("accessSpec", _accessSpec);
                this.writer.endTag();
            }
            catch (IOException _e) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn("Error while writing xmlized jimple info.", (Throwable)_e);
            }
        }
    }

    public final void callback(SootMethod method) {
        block7: {
            try {
                if (this.processingMethod) {
                    this.writer.endTag();
                } else {
                    this.processingMethod = true;
                }
                this.writer.startTag("method");
                this.writer.attribute("name", AbstractXMLizer.xmlizeString(method.getName()));
                this.writer.attribute("id", this.idGenerator.getIdForMethod(method));
                this.writer.attribute("abstract", String.valueOf(method.isAbstract()));
                this.writer.attribute("static", String.valueOf(method.isStatic()));
                this.writer.attribute("native", String.valueOf(method.isNative()));
                this.writer.attribute("synchronized", String.valueOf(method.isSynchronized()));
                this.writer.attribute("accessSpec", this.getAccessSpecifier(method.getModifiers()));
                this.writer.startTag("signature");
                this.writer.startTag("returnType");
                this.writer.attribute("typeId", this.idGenerator.getIdForType(method.getReturnType()));
                this.writer.endTag();
                int _j = 0;
                Iterator _i = method.getParameterTypes().iterator();
                while (_i.hasNext()) {
                    this.writer.startTag("paramType");
                    this.writer.attribute("typeId", this.idGenerator.getIdForType((Type)_i.next()));
                    this.writer.attribute("position", String.valueOf(_j++));
                    this.writer.endTag();
                }
                _i = method.getExceptions().iterator();
                while (_i.hasNext()) {
                    this.writer.startTag("exception");
                    this.writer.attribute("typeId", this.idGenerator.getIdForClass((SootClass)_i.next()));
                    this.writer.endTag();
                }
                this.writer.endTag();
                if (method.isConcrete()) {
                    this.xmlizeTrapListAndLocals(method);
                }
            }
            catch (IOException _e) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn("Error while writing xmlized jimple info.", (Throwable)_e);
            }
        }
    }

    public final void callback(Stmt stmt, Context context) {
        this.stmtXmlizer.setMethod(context.getCurrentMethod());
        this.stmtXmlizer.apply(stmt);
    }

    public final void consolidate() {
        block3: {
            if (this.writer != null) {
                try {
                    this.writer.endDocument();
                    this.writer.getWriter().close();
                }
                catch (IOException _e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Error while writing xmlized jimple info.", (Throwable)_e);
                }
            }
        }
    }

    public final void hookup(ProcessingController ppc) {
        ppc.registerForAllStmts(this);
        ppc.register(this);
    }

    public final void setDumpOptions(String directory, String suffix) {
        File _dir;
        this.dumpDirectory = directory;
        if (directory != null && !(_dir = new File(directory)).exists()) {
            _dir.mkdirs();
        }
        this.fileSuffix = suffix == null ? "" : "_" + suffix;
    }

    public final void unhook(ProcessingController ppc) {
        ppc.unregisterForAllStmts(this);
        ppc.unregister(this);
    }

    private String getAccessSpecifier(int modifiers) {
        String _result = "";
        if (Modifier.isPublic((int)modifiers)) {
            _result = "public";
        } else if (Modifier.isPrivate((int)modifiers)) {
            _result = "private";
        } else if (Modifier.isProtected((int)modifiers)) {
            _result = "proctected";
        }
        return _result;
    }

    private String setupFile(SootClass clazz) throws IOException {
        String _classId = this.idGenerator.getIdForClass(clazz);
        if (this.dumpDirectory == null) {
            if (this.writer == null) {
                this.writer = new CustomXMLOutputter(new BufferedWriter(new OutputStreamWriter(System.out)));
            } else {
                this.writer.reset(this.writer.getWriter(), this.writer.getEncoding());
            }
            this.stmtXmlizer.setWriter(this.writer);
        } else {
            String _filename = String.valueOf(this.dumpDirectory) + File.separator + _classId + this.fileSuffix + ".xml";
            try {
                if (this.writer != null && this.writer.getWriter() != null) {
                    this.writer.getWriter().close();
                }
                File _file = new File(_filename);
                this.writer = new CustomXMLOutputter(new BufferedWriter(new FileWriter(_file)));
                this.stmtXmlizer.setWriter(this.writer);
                this.writer.declaration();
            }
            catch (IOException _e) {
                LOGGER.error("Exception while trying to open " + _filename, (Throwable)_e);
                throw _e;
            }
        }
        return _classId;
    }

    private void xmlizeTrapListAndLocals(SootMethod method) {
        block5: {
            Body _body = method.retrieveActiveBody();
            Chain _traps = _body.getTraps();
            try {
                if (!_traps.isEmpty()) {
                    this.writer.startTag("traplist");
                    for (Trap _trap : _traps) {
                        this.writer.startTag("trap");
                        this.writer.attribute("typeId", this.idGenerator.getIdForClass(_trap.getException()));
                        this.writer.attribute("beginId", this.idGenerator.getIdForStmt((Stmt)_trap.getBeginUnit(), method));
                        this.writer.attribute("endId", this.idGenerator.getIdForStmt((Stmt)_trap.getEndUnit(), method));
                        this.writer.attribute("handlerId", this.idGenerator.getIdForStmt((Stmt)_trap.getHandlerUnit(), method));
                        this.writer.endTag();
                    }
                    this.writer.endTag();
                }
                for (Local _l : _body.getLocals()) {
                    this.writer.startTag("local");
                    this.writer.attribute("id", this.idGenerator.getIdForLocal(_l, method));
                    this.writer.attribute("name", _l.getName());
                    this.writer.attribute("typeId", this.idGenerator.getIdForType(_l.getType()));
                    this.writer.endTag();
                }
            }
            catch (IOException _e) {
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn("Error while writing xmlized jimple info.", (Throwable)_e);
            }
        }
    }
}

