/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import java.io.IOException;
import org.znerd.xmlenc.XMLOutputter;
import soot.ArrayType;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EqExpr;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GtExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.ThisRef;
import soot.jimple.UnopExpr;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.util.Switch;

public class JimpleValueXMLizer
extends AbstractJimpleValueSwitch {
    final StringBuffer tabs = new StringBuffer("\t\t\t");
    private SootMethod currMethod;
    private Stmt currStmt;
    private final IJimpleIDGenerator idGenerator;
    private Object newId;
    private XMLOutputter xmlWriter;

    JimpleValueXMLizer(IJimpleIDGenerator generator) {
        this.idGenerator = generator;
    }

    public final void caseAddExpr(AddExpr v) {
        this.writeBinaryExpr("add", (BinopExpr)v);
    }

    public final void caseAndExpr(AndExpr v) {
        this.writeBinaryExpr("binary and", (BinopExpr)v);
    }

    public final void caseArrayRef(ArrayRef v) {
        try {
            this.xmlWriter.startTag("array_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.writeBase(v.getBaseBox());
            this.xmlWriter.startTag("index");
            this.apply(v.getIndexBox());
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseCastExpr(CastExpr v) {
        try {
            this.xmlWriter.startTag("cast");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("typeId", this.idGenerator.getIdForType(v.getCastType()));
            this.apply(v.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseCaughtExceptionRef(CaughtExceptionRef v) {
        try {
            this.xmlWriter.startTag("caught_exception_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("exceptionTypeId", this.idGenerator.getIdForType(v.getType()));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseCmpExpr(CmpExpr v) {
        this.writeBinaryExpr("compare", (BinopExpr)v);
    }

    public final void caseCmpgExpr(CmpgExpr v) {
        this.writeBinaryExpr("compare greater", (BinopExpr)v);
    }

    public final void caseCmplExpr(CmplExpr v) {
        this.writeBinaryExpr("compare lesser", (BinopExpr)v);
    }

    public final void caseDivExpr(DivExpr v) {
        this.writeBinaryExpr("divide", (BinopExpr)v);
    }

    public final void caseDoubleConstant(DoubleConstant v) {
        try {
            this.xmlWriter.startTag("double");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("value", String.valueOf(v.value));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseEqExpr(EqExpr v) {
        this.writeBinaryExpr("equal", (BinopExpr)v);
    }

    public final void caseFloatConstant(FloatConstant v) {
        try {
            this.xmlWriter.startTag("float");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("value", String.valueOf(v.value));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseGeExpr(GeExpr v) {
        this.writeBinaryExpr("greater than or equal", (BinopExpr)v);
    }

    public final void caseGtExpr(GtExpr v) {
        this.writeBinaryExpr("greater than", (BinopExpr)v);
    }

    public final void caseInstanceFieldRef(InstanceFieldRef v) {
        try {
            this.xmlWriter.startTag("instance_field_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.writeBase(v.getBaseBox());
            this.writeField(v.getField());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseInstanceOfExpr(InstanceOfExpr v) {
        try {
            this.xmlWriter.startTag("instanceof");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("typeId", this.idGenerator.getIdForType(v.getCheckType()));
            this.apply(v.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseIntConstant(IntConstant v) {
        try {
            this.xmlWriter.startTag("integer");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("value", String.valueOf(v.value));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseInterfaceInvokeExpr(InterfaceInvokeExpr v) {
        this.writeInvokeExpr((InvokeExpr)v);
    }

    public final void caseLeExpr(LeExpr v) {
        this.writeBinaryExpr("less than or equal", (BinopExpr)v);
    }

    public final void caseLengthExpr(LengthExpr v) {
        this.writeUnaryExpr("length", (UnopExpr)v);
    }

    public final void caseLocal(Local v) {
        try {
            this.xmlWriter.startTag("local_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("localId", this.idGenerator.getIdForLocal(v, this.currMethod));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseLongConstant(LongConstant v) {
        try {
            this.xmlWriter.startTag("long");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("value", String.valueOf(v.value));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseLtExpr(LtExpr v) {
        this.writeBinaryExpr("less than", (BinopExpr)v);
    }

    public final void caseMulExpr(MulExpr v) {
        this.writeBinaryExpr("multiply", (BinopExpr)v);
    }

    public final void caseNeExpr(NeExpr v) {
        this.writeBinaryExpr("not equal", (BinopExpr)v);
    }

    public final void caseNegExpr(NegExpr v) {
        this.writeUnaryExpr("negation", (UnopExpr)v);
    }

    public final void caseNewArrayExpr(NewArrayExpr v) {
        try {
            this.xmlWriter.startTag("new_array");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("typeId", this.idGenerator.getIdForType(v.getBaseType()));
            this.writeDimensionSize(1, v.getSizeBox());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseNewExpr(NewExpr v) {
        try {
            this.xmlWriter.startTag("new");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("typeId", this.idGenerator.getIdForType(v.getType()));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseNewMultiArrayExpr(NewMultiArrayExpr v) {
        ArrayType _type = v.getBaseType();
        try {
            this.xmlWriter.startTag("new_multi_array");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("typeId", this.idGenerator.getIdForType(_type.baseType));
            this.xmlWriter.attribute("dimension", String.valueOf(_type.numDimensions));
            int _i = 0;
            while (_i < v.getSizeCount()) {
                this.writeDimensionSize(_i + 1, v.getSizeBox(_i));
                ++_i;
            }
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseNullConstant(NullConstant v) {
        try {
            this.xmlWriter.startTag("null");
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseOrExpr(OrExpr v) {
        this.writeBinaryExpr("binary or", (BinopExpr)v);
    }

    public final void caseParameterRef(ParameterRef v) {
        try {
            this.xmlWriter.startTag("parameter_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("position", String.valueOf(v.getIndex()));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseRemExpr(RemExpr v) {
        this.writeBinaryExpr("reminder", (BinopExpr)v);
    }

    public final void caseShlExpr(ShlExpr v) {
        this.writeBinaryExpr("shift left", (BinopExpr)v);
    }

    public final void caseShrExpr(ShrExpr v) {
        this.writeBinaryExpr("shift right", (BinopExpr)v);
    }

    public final void caseSpecialInvokeExpr(SpecialInvokeExpr v) {
        this.writeInvokeExpr((InvokeExpr)v);
    }

    public final void caseStaticFieldRef(StaticFieldRef v) {
        try {
            this.xmlWriter.startTag("static_field_ref");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.writeField(v.getField());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseStaticInvokeExpr(StaticInvokeExpr v) {
        this.writeInvokeExpr((InvokeExpr)v);
    }

    public final void caseStringConstant(StringConstant v) {
        try {
            this.xmlWriter.startTag("string");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.cdata(AbstractXMLizer.encode(String.valueOf(v.value), this.xmlWriter.getEncoding()));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseSubExpr(SubExpr v) {
        this.writeBinaryExpr("subtract", (BinopExpr)v);
    }

    public final void caseThisRef(ThisRef v) {
        try {
            this.xmlWriter.startTag("this");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public final void caseUshrExpr(UshrExpr v) {
        this.writeBinaryExpr("unsigned shift right", (BinopExpr)v);
    }

    public final void caseVirtualInvokeExpr(VirtualInvokeExpr v) {
        this.writeInvokeExpr((InvokeExpr)v);
    }

    public final void caseXorExpr(XorExpr v) {
        this.writeBinaryExpr("binary xor", (BinopExpr)v);
    }

    final void apply(ValueBox programPoint) {
        Object _temp = this.newId;
        this.newId = this.idGenerator.getIdForValueBox(programPoint, this.currStmt, this.currMethod);
        this.incrementTabs();
        programPoint.getValue().apply((Switch)this);
        this.decrementTabs();
        this.newId = _temp;
    }

    final void setMethod(SootMethod method) {
        this.currMethod = method;
    }

    final void setStmt(Stmt stmt) {
        this.currStmt = stmt;
    }

    final void setWriter(XMLOutputter outputter) {
        this.xmlWriter = outputter;
    }

    private void decrementTabs() {
        this.tabs.deleteCharAt(0);
    }

    private void incrementTabs() {
        this.tabs.append("\t");
    }

    private void writeBase(ValueBox base) {
        try {
            this.xmlWriter.startTag("base");
            this.apply(base);
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    private void writeBinaryExpr(String operatorName, BinopExpr v) {
        try {
            this.xmlWriter.startTag("binary_expr");
            this.xmlWriter.attribute("id", this.newId.toString());
            this.xmlWriter.attribute("op", operatorName);
            this.xmlWriter.startTag("left_op");
            this.apply(v.getOp1Box());
            this.xmlWriter.endTag();
            this.xmlWriter.startTag("right_op");
            this.apply(v.getOp2Box());
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    private void writeDimensionSize(int i, ValueBox v) {
        try {
            this.xmlWriter.startTag("size");
            this.xmlWriter.attribute("dimension", String.valueOf(i));
            this.apply(v);
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    private void writeField(SootField field) {
        try {
            this.xmlWriter.startTag("field_ref");
            this.xmlWriter.attribute("fieldId", this.idGenerator.getIdForField(field));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    private void writeInvokeExpr(InvokeExpr v) {
        String _name = "";
        if (v instanceof InterfaceInvokeExpr) {
            _name = "interface";
        } else if (v instanceof SpecialInvokeExpr) {
            _name = "special";
        } else if (v instanceof StaticInvokeExpr) {
            _name = "static";
        } else if (v instanceof VirtualInvokeExpr) {
            _name = "virtual";
        } else {
            throw new IllegalArgumentException("v has to be of VirtualInvokeExpr, StaticInvokeExpr, SpecialInvokeExpr, or InterfaceInvokeExpr.");
        }
        try {
            this.xmlWriter.startTag("invoke_expr");
            this.xmlWriter.attribute("name", _name);
            this.xmlWriter.attribute("id", this.newId.toString());
            SootMethod _method = v.getMethod();
            this.xmlWriter.startTag("method_ref");
            this.xmlWriter.attribute("methodId", this.idGenerator.getIdForMethod(_method));
            this.xmlWriter.endTag();
            if (v instanceof InstanceInvokeExpr) {
                this.writeBase(((InstanceInvokeExpr)v).getBaseBox());
            }
            if (v.getArgCount() > 0) {
                this.xmlWriter.startTag("arguments");
                int _i = 0;
                while (_i < v.getArgCount()) {
                    this.apply(v.getArgBox(_i));
                    ++_i;
                }
                this.xmlWriter.endTag();
            }
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    private void writeUnaryExpr(String operatorName, UnopExpr value) {
        try {
            this.xmlWriter.startTag("unary_expr");
            this.xmlWriter.attribute("op", operatorName);
            this.xmlWriter.attribute("id", this.newId.toString());
            this.apply(value.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }
}

