/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.JimpleValueXMLizer;
import java.io.IOException;
import org.znerd.xmlenc.XMLOutputter;
import soot.Body;
import soot.SootMethod;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AssignStmt;
import soot.jimple.BreakpointStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NopStmt;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.util.Switch;

final class JimpleStmtXMLizer
extends AbstractStmtSwitch {
    JimpleValueXMLizer valueXMLizer;
    private SootMethod currMethod;
    private Body currMethodBody;
    private final IJimpleIDGenerator idGenerator;
    private XMLOutputter xmlWriter;

    JimpleStmtXMLizer(JimpleValueXMLizer theValueXMLizer, IJimpleIDGenerator generator) {
        this.valueXMLizer = theValueXMLizer;
        this.idGenerator = generator;
    }

    public void caseAssignStmt(AssignStmt v) {
        try {
            boolean _notEmpty = !v.getBoxesPointingToThis().isEmpty();
            this.xmlWriter.startTag("assign_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(_notEmpty));
            this.xmlWriter.startTag("lhs");
            this.valueXMLizer.apply(v.getLeftOpBox());
            this.xmlWriter.endTag();
            this.xmlWriter.startTag("rhs");
            this.valueXMLizer.apply(v.getRightOpBox());
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseBreakpointStmt(BreakpointStmt v) {
        try {
            this.xmlWriter.startTag("breakpoint_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseEnterMonitorStmt(EnterMonitorStmt v) {
        try {
            this.xmlWriter.startTag("entermonitor_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(v.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseExitMonitorStmt(ExitMonitorStmt v) {
        try {
            this.xmlWriter.startTag("exitmonitor_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(v.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseGotoStmt(GotoStmt v) {
        try {
            this.xmlWriter.startTag("goto_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("target", this.idGenerator.getIdForStmt((Stmt)v.getTarget(), this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseIdentityStmt(IdentityStmt v) {
        try {
            this.xmlWriter.startTag("identity_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.startTag("lhs");
            this.valueXMLizer.apply(v.getLeftOpBox());
            this.xmlWriter.endTag();
            this.xmlWriter.startTag("rhs");
            this.valueXMLizer.apply(v.getRightOpBox());
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseIfStmt(IfStmt v) {
        try {
            this.xmlWriter.startTag("if_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.attribute("trueTargetId", this.idGenerator.getIdForStmt(v.getTarget(), this.currMethod));
            this.xmlWriter.attribute("falseTargetId", this.idGenerator.getIdForStmt((Stmt)this.currMethodBody.getUnits().getSuccOf((Object)v), this.currMethod));
            this.xmlWriter.startTag("condition");
            this.valueXMLizer.apply(v.getConditionBox());
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseInvokeStmt(InvokeStmt v) {
        try {
            this.xmlWriter.startTag("invoke_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(v.getInvokeExprBox());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseLookupSwitchStmt(LookupSwitchStmt v) {
        try {
            this.xmlWriter.startTag("lookupswitch_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.attribute("defaultTargetId", this.idGenerator.getIdForStmt((Stmt)v.getDefaultTarget(), this.currMethod));
            this.xmlWriter.startTag("key");
            this.valueXMLizer.apply(v.getKeyBox());
            this.xmlWriter.endTag();
            int _i = 0;
            while (_i < v.getTargetCount()) {
                this.xmlWriter.startTag("case");
                this.xmlWriter.attribute("value", String.valueOf(v.getLookupValue(_i)));
                this.xmlWriter.attribute("targetId", this.idGenerator.getIdForStmt((Stmt)v.getTarget(_i), this.currMethod));
                this.xmlWriter.endTag();
                ++_i;
            }
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseNopStmt(NopStmt v) {
        try {
            this.xmlWriter.startTag("nop_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseRetStmt(RetStmt v) {
        try {
            this.xmlWriter.startTag("ret_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(v.getStmtAddressBox());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseReturnStmt(ReturnStmt v) {
        try {
            this.xmlWriter.startTag("return_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(v.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseReturnVoidStmt(ReturnVoidStmt v) {
        try {
            this.xmlWriter.startTag("returnvoid_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseTableSwitchStmt(TableSwitchStmt v) {
        try {
            this.xmlWriter.startTag("tableswitch_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.xmlWriter.attribute("defaultTargetId", this.idGenerator.getIdForStmt((Stmt)v.getDefaultTarget(), this.currMethod));
            this.xmlWriter.startTag("key");
            this.valueXMLizer.apply(v.getKeyBox());
            this.xmlWriter.endTag();
            int _i = 0;
            while (_i < v.getHighIndex() - v.getLowIndex()) {
                this.xmlWriter.startTag("case");
                this.xmlWriter.attribute("value", String.valueOf(_i));
                this.xmlWriter.attribute("targetId", this.idGenerator.getIdForStmt((Stmt)v.getTarget(_i), this.currMethod));
                this.xmlWriter.endTag();
                ++_i;
            }
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    public void caseThrowStmt(ThrowStmt v) {
        try {
            this.xmlWriter.startTag("throw_stmt");
            this.xmlWriter.attribute("id", this.idGenerator.getIdForStmt((Stmt)v, this.currMethod));
            this.xmlWriter.attribute("label", String.valueOf(!v.getBoxesPointingToThis().isEmpty()));
            this.valueXMLizer.apply(v.getOpBox());
            this.xmlWriter.endTag();
        }
        catch (IOException _e) {
            _e.printStackTrace();
        }
    }

    void apply(Stmt stmt) {
        this.valueXMLizer.setStmt(stmt);
        stmt.apply((Switch)this);
    }

    void setMethod(SootMethod method) {
        this.currMethod = method;
        this.currMethodBody = method.isConcrete() ? method.retrieveActiveBody() : null;
        this.valueXMLizer.setMethod(method);
    }

    void setWriter(XMLOutputter outputter) {
        this.xmlWriter = outputter;
        this.valueXMLizer.setWriter(outputter);
    }
}

