/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.xmlizer;

import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.IXMLizer;
import edu.ksu.cis.indus.xmlizer.JimpleXMLizer;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXMLizer
implements IXMLizer {
    public static final Object FILE_NAME_ID = "FILE_NAME_ID";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXMLizer.class);
    private static final int LOWER_NIBBLE_MASK = 15;
    private static final int NO_SHIFTS_FROM_HIGHER_TO_LOWER_NIBBLE = 4;
    private IJimpleIDGenerator idGenerator;
    private String xmlOutDir;

    public static String encode(String string, String encoding) {
        Charset _cs = Charset.forName(encoding);
        ByteBuffer _bb = _cs.encode(string);
        byte[] _bytes = _bb.array();
        StringBuffer _sb = new StringBuffer("\\u");
        int _i = 0;
        while (_i < _bytes.length) {
            byte _b = _bytes[_i];
            char[] _chars = new char[]{HEX_DIGITS[_b >> 4 & 0xF], HEX_DIGITS[_b & 0xF]};
            _sb.append(new String(_chars));
            ++_i;
        }
        return _sb.toString();
    }

    public static final String xmlizeString(String string) {
        String _result = "";
        if (string != null) {
            char[] _chars = string.toCharArray();
            boolean _needsEncoding = AbstractXMLizer.needsEncoding(_chars);
            String _ret = string;
            if (_needsEncoding) {
                StringBuffer _strBuf = new StringBuffer();
                int _i = 0;
                while (_i < _chars.length) {
                    switch (_chars[_i]) {
                        case '&': {
                            _strBuf.append("&amp;");
                            break;
                        }
                        case '\"': {
                            _strBuf.append("&quot;");
                            break;
                        }
                        case '\'': {
                            _strBuf.append("&apos;");
                            break;
                        }
                        case '<': {
                            _strBuf.append("&lt;");
                            break;
                        }
                        case '\r': {
                            _strBuf.append("&#xd;");
                            break;
                        }
                        case '>': {
                            _strBuf.append("&gt;");
                            break;
                        }
                        default: {
                            if (_chars[_i] > '\u007f') {
                                _strBuf.append("&#");
                                _strBuf.append((int)_chars[_i]);
                                _strBuf.append(";");
                                break;
                            }
                            _strBuf.append(_chars[_i]);
                        }
                    }
                    ++_i;
                }
                _ret = _strBuf.toString();
            }
            _result = _ret.replaceAll(":", "_");
        }
        return _result;
    }

    private static boolean needsEncoding(char[] charArray) {
        boolean _needsEncoding = false;
        int _i = 0;
        block3: while (_i < charArray.length) {
            switch (charArray[_i]) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    _needsEncoding = true;
                    break block3;
                }
                default: {
                    ++_i;
                }
            }
        }
        return _needsEncoding;
    }

    public final void dumpJimple(String name, String dumpDir, ProcessingController xmlcgipc) {
        JimpleXMLizer _t = new JimpleXMLizer(this.idGenerator);
        _t.setDumpOptions(dumpDir, this.getFileName(name).replaceAll("\\.xml$", ""));
        _t.hookup(xmlcgipc);
        xmlcgipc.process();
        _t.unhook(xmlcgipc);
    }

    public final IJimpleIDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public final String getXmlOutputDir() {
        return this.xmlOutDir;
    }

    public final void setGenerator(IJimpleIDGenerator generator) {
        this.idGenerator = generator;
    }

    public final void setXmlOutputDir(String xmlOutputDir) {
        File _f = new File(xmlOutputDir);
        if (!_f.exists() | !_f.canWrite()) {
            LOGGER.error("XML output directory should exists with proper permissions.");
            throw new IllegalArgumentException("XML output directory should exists with proper permissions.");
        }
        this.xmlOutDir = xmlOutputDir;
    }
}

