/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools;

import edu.ksu.cis.indus.annotations.Empty;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Phase
implements Cloneable {
    public static final Phase FINISHED_PHASE;
    public static final Phase STARTING_PHASE;
    private static final Logger LOGGER;
    private int major;
    private int minor;

    static {
        Phase _i;
        LOGGER = LoggerFactory.getLogger(Phase.class);
        STARTING_PHASE = _i = new Phase();
        _i = new Phase();
        _i.finished();
        FINISHED_PHASE = _i;
    }

    @Empty
    private Phase() {
    }

    public static Phase createPhase() {
        Phase _result = new Phase();
        _result.major = 0;
        _result.minor = 0;
        return _result;
    }

    public Phase clone() {
        Phase _result;
        block2: {
            _result = null;
            try {
                _result = (Phase)super.clone();
                _result.major = this.major;
                _result.minor = this.minor;
            }
            catch (CloneNotSupportedException _e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("Cloning of phase failed.", (Throwable)_e);
            }
        }
        return _result;
    }

    public boolean equals(Object o) {
        boolean _result = false;
        if (o instanceof Phase) {
            Phase _p = (Phase)o;
            _result = this.equalsMajor(_p) && this.equalsMinor(_p);
        }
        return _result;
    }

    public boolean equalsMajor(Phase p) {
        return this.major == p.major;
    }

    public boolean equalsMinor(Phase p) {
        return this.minor == p.minor;
    }

    public void finished() {
        this.major = Integer.MAX_VALUE;
        this.minor = Integer.MAX_VALUE;
    }

    public int hashCode() {
        return this.major + this.minor;
    }

    public boolean isEarlierThan(Phase phase) {
        return this.major < phase.major || this.major == phase.major && this.minor < phase.minor;
    }

    public void nextMajorPhase() {
        ++this.major;
        this.minor = 0;
    }

    public void nextMinorPhase() {
        ++this.minor;
    }

    public void reset() {
        this.major = 0;
        this.minor = 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("minor", this.minor).append("major", this.major).toString();
    }
}

