/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.tools.AbstractToolConfigurator;
import edu.ksu.cis.indus.tools.CompositeToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfigurationFactory;
import edu.ksu.cis.indus.tools.IToolConfigurator;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public final class CompositeToolConfigurator
extends AbstractToolConfigurator {
    private Composite childComposite;
    private IToolConfigurator childConfigurator;
    private CompositeToolConfiguration compositeConfiguration;
    private Combo configCombo;
    private int selectedIndex;
    private IToolConfigurationFactory toolConfigFactory;

    public CompositeToolConfigurator(CompositeToolConfiguration compositeConfigs, IToolConfigurator child, IToolConfigurationFactory factory) {
        this.compositeConfiguration = compositeConfigs;
        this.childConfigurator = child;
        this.toolConfigFactory = factory;
    }

    @Empty
    protected void checkConfiguration(IToolConfiguration t) {
    }

    protected void setup() {
        GridLayout _gridLayout = new GridLayout();
        _gridLayout.numColumns = 3;
        this.parent.setLayout((Layout)_gridLayout);
        Label _label = new Label(this.parent, 0);
        GridData _gridData = new GridData();
        _gridData.horizontalSpan = 1;
        _label.setLayoutData((Object)_gridData);
        _label.setText("Configurations:");
        this.configCombo = new Combo(this.parent, 4);
        this.configCombo.setItems(new String[0]);
        this.configCombo.setLayoutData((Object)new GridData(768));
        this.configCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }

            public void widgetSelected(SelectionEvent evt) {
                CompositeToolConfigurator.this.recordSelection();
                CompositeToolConfigurator.this.displayChild();
                CompositeToolConfigurator.this.parent.layout();
                CompositeToolConfigurator.this.parent.pack();
            }
        });
        this.configCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                CompositeToolConfigurator.this.recordSelection();
            }

            public void focusLost(FocusEvent evt) {
                CompositeToolConfigurator.this.updateConfigName();
            }
        });
        this.configCombo.setVisible(true);
        Button _newConfig = new Button(this.parent, 8);
        _newConfig.setText("Create");
        _gridData = new GridData(128);
        _gridData.horizontalIndent = _newConfig.getText().length();
        _newConfig.setLayoutData((Object)_gridData);
        _newConfig.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }

            public void widgetSelected(SelectionEvent evt) {
                CompositeToolConfigurator.this.createNewConfiguration();
                CompositeToolConfigurator.this.displayChild();
                CompositeToolConfigurator.this.parent.layout();
                CompositeToolConfigurator.this.parent.pack();
            }
        });
        if (this.compositeConfiguration.configurations.isEmpty()) {
            this.compositeConfiguration.configurations.add(this.toolConfigFactory.createToolConfiguration());
        }
        for (IToolConfiguration _config : this.compositeConfiguration.configurations) {
            this.configCombo.add(_config.getConfigName());
        }
        IToolConfiguration _c = this.compositeConfiguration.getActiveToolConfiguration();
        this.configCombo.select(this.compositeConfiguration.configurations.indexOf(_c));
        this.displayChild();
    }

    void createNewConfiguration() {
        IToolConfiguration _temp = this.toolConfigFactory.createToolConfiguration();
        _temp.setConfigName("tool_configuration_" + this.compositeConfiguration.configurations.size());
        this.compositeConfiguration.addToolConfiguration(_temp);
        this.configCombo.add(_temp.getConfigName());
        this.configCombo.select(this.compositeConfiguration.configurations.indexOf(_temp));
    }

    void displayChild() {
        if (this.childComposite != null) {
            this.childComposite.dispose();
        }
        this.childComposite = new Composite(this.parent, 0);
        GridData _gridData = new GridData(768);
        _gridData.horizontalSpan = 3;
        this.childComposite.setLayoutData((Object)_gridData);
        this.childComposite.setVisible(true);
        int _index = this.configCombo.getSelectionIndex();
        if (_index != -1) {
            IToolConfiguration _tc = this.compositeConfiguration.configurations.get(_index);
            this.compositeConfiguration.setActiveToolConfiguration(_tc);
            this.childConfigurator.setConfiguration(_tc);
            this.childConfigurator.initialize(this.childComposite);
        }
    }

    void recordSelection() {
        this.selectedIndex = this.configCombo.getSelectionIndex();
    }

    void updateConfigName() {
        int _selIndex = this.configCombo.getSelectionIndex();
        if (_selIndex < 0) {
            List<IToolConfiguration> _configurations = this.compositeConfiguration.configurations;
            IToolConfiguration _selConfig = _configurations.get(this.selectedIndex);
            String _newText = this.configCombo.getText();
            boolean _noDuplicate = true;
            int _i = this.configCombo.getItemCount() - 1;
            while (_i >= 0 && _noDuplicate) {
                if (_configurations.get(_i).getConfigName().equals(_newText)) {
                    MessageBox _msgBox = new MessageBox(this.parent.getShell(), 34);
                    _msgBox.setMessage("A configuration with the name of \"" + _newText + "\" exists.  \nNo changes will be made.");
                    _msgBox.open();
                    _noDuplicate = false;
                }
                --_i;
            }
            if (_noDuplicate) {
                _selConfig.setConfigName(_newText);
                this.configCombo.remove(this.selectedIndex);
                this.configCombo.add(_newText, this.selectedIndex);
            }
        }
    }
}

