/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.tools.AbstractToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.JiBX_MungeAdapter;
import java.util.ArrayList;
import java.util.List;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeToolConfiguration
extends AbstractToolConfiguration
implements IUnmarshallable,
IMarshallable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeToolConfiguration.class);
    final List<IToolConfiguration> configurations = new ArrayList<IToolConfiguration>();
    private String activeConfigID;
    public static final String JiBX_bindingList = "|edu.ksu.cis.indus.tools.JiBX_slicerConfig_JiBXBindingFactory|";

    public static List createConfigurations() {
        return new ArrayList();
    }

    public void addToolConfiguration(IToolConfiguration config) {
        if (config == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Null configurations are not supported.");
            }
        } else if (this.configurations.contains(config)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("The given configurationCollection exists.");
            }
        } else {
            this.configurations.add(config);
        }
    }

    public String getActiveToolConfigurationID() {
        return this.getActiveToolConfiguration().getConfigName();
    }

    @Override
    @Empty
    public void initialize() {
    }

    public void setActiveToolConfiguration(IToolConfiguration config) {
        if (this.configurations.contains(config)) {
            this.activeConfigID = config.getConfigName();
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("The given configuration is not part of this collection.  It was not activated.");
        }
    }

    public void setActiveToolConfigurationID(String id) {
        if (this.configurations.isEmpty()) {
            this.activeConfigID = id;
        } else {
            String _temp = null;
            for (IToolConfiguration _config : this.configurations) {
                if (!_config.getConfigName().equals(id)) continue;
                _temp = id;
            }
            if (_temp != null) {
                this.activeConfigID = _temp;
            } else {
                String _msg = "setActiveToolConfigurationID(id = " + id + ") - Configuration with given ID does not exist.";
                LOGGER.error(_msg);
                throw new RuntimeException(_msg);
            }
        }
    }

    public void setConfigurations(List<IToolConfiguration> configs) {
        this.configurations.clear();
        this.configurations.addAll(configs);
    }

    protected boolean processProperty(Comparable propertyID, Object value) {
        IToolConfiguration _ac = this.getActiveToolConfiguration();
        return ((AbstractToolConfiguration)_ac).processProperty(propertyID, value);
    }

    IToolConfiguration getActiveToolConfiguration() {
        IToolConfiguration _result = null;
        for (IToolConfiguration _config : this.configurations) {
            if (!_config.getConfigName().equals(this.activeConfigID)) continue;
            _result = _config;
            break;
        }
        if (_result == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Selecting the first configuration as active configurationCollection.");
            }
            if ((_result = this.configurations.get(0)) != null) {
                this.activeConfigID = _result.getConfigName();
            } else {
                throw new RuntimeException("There are no configurations.");
            }
        }
        return _result;
    }

    public static /* synthetic */ CompositeToolConfiguration JiBX_slicerConfig_JiBXBinding_newinstance_2_0(UnmarshallingContext arg1) throws JiBXException {
        return new CompositeToolConfiguration();
    }

    public final /* synthetic */ CompositeToolConfiguration JiBX_slicerConfig_JiBXBinding_unmarshalAttr_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        CompositeToolConfiguration compositeToolConfiguration = this;
        this.setActiveToolConfigurationID(arg1.attributeText("http://indus.projects.cis.ksu.edu/indus", "activeConfiguration"));
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ CompositeToolConfiguration JiBX_slicerConfig_JiBXBinding_unmarshal_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        CompositeToolConfiguration compositeToolConfiguration = this;
        List list = this.configurations;
        if (list == null) {
            list = JiBX_MungeAdapter.JiBX_slicerConfig_JiBXBinding_newinstance_1_0(arg1);
        }
        this.configurations = JiBX_MungeAdapter.JiBX_slicerConfig_JiBXBinding_unmarshal_1_0(list, arg1);
        arg1.popObject();
        return this;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(0).unmarshal((Object)this, arg1);
    }

    public final /* synthetic */ void JiBX_slicerConfig_JiBXBinding_marshalAttr_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.attribute(3, "activeConfiguration", this.getActiveToolConfigurationID());
        arg1.popObject();
    }

    public final /* synthetic */ void JiBX_slicerConfig_JiBXBinding_marshal_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        JiBX_MungeAdapter.JiBX_slicerConfig_JiBXBinding_marshal_1_0(this.configurations, arg1);
        arg1.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(0, "edu.ksu.cis.indus.tools.CompositeToolConfiguration").marshal((Object)this, arg1);
    }

    public /* synthetic */ int JiBX_getIndex() {
        return 0;
    }
}

