/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools;

import edu.ksu.cis.indus.tools.AbstractTool;
import edu.ksu.cis.indus.tools.Phase;
import junit.framework.TestCase;

public class AbstractToolTest
extends TestCase {
    private TestTool testTool;

    public final void testAbortInAsyncMode() {
        Phase _ph = Phase.createPhase();
        this.testTool.run(_ph, null, false);
        if (!this.testTool.finished) {
            this.testTool.abort();
        }
        try {
            this.testTool.run(_ph, null, false);
        }
        catch (Exception exception) {
            AbstractToolTest.fail((String)"This should not happen.");
        }
    }

    public final void testAbortInSyncMode() {
        final Phase _ph = Phase.createPhase();
        this.testTool.pause();
        Thread _thread = new Thread(new Runnable(){

            public void run() {
                AbstractToolTest.this.testTool.run(_ph, null, true);
            }
        });
        _thread.start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            AbstractToolTest.fail((String)"This should not happen.");
        }
        AbstractToolTest.assertFalse((boolean)this.testTool.finished);
        this.testTool.abort();
        this.testTool.finished = false;
        this.testTool.run(_ph, null, true);
        AbstractToolTest.assertTrue((boolean)this.testTool.finished);
    }

    public final void testPauseAndResumeInAsyncMode() {
        try {
            this.testTool.pause();
        }
        catch (Exception exception) {
            AbstractToolTest.fail((String)"Should be able to pause tool that is not running.");
        }
        Phase _ph = Phase.createPhase();
        this.testTool.pause();
        this.testTool.run(_ph, null, false);
        _ph.nextMinorPhase();
        AbstractToolTest.assertTrue((boolean)this.testTool.localPH.isEarlierThan(_ph));
        this.testTool.resume();
        while (!this.testTool.finished) {
        }
        AbstractToolTest.assertTrue((boolean)_ph.isEarlierThan(this.testTool.localPH));
    }

    public final void testPauseAndResumeInSyncMode() {
        try {
            this.testTool.pause();
        }
        catch (Exception exception) {
            AbstractToolTest.fail((String)"Should be able to pause tool that is not running.");
        }
        final Phase _ph = Phase.createPhase();
        this.testTool.pause();
        Thread _thread = new Thread(new Runnable(){

            public void run() {
                AbstractToolTest.this.testTool.run(_ph, null, true);
            }
        });
        try {
            _thread.start();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            AbstractToolTest.fail((String)"This should not happen.");
        }
        AbstractToolTest.assertTrue((boolean)_ph.equalsMajor(this.testTool.localPH));
        AbstractToolTest.assertTrue((boolean)_ph.equalsMinor(this.testTool.localPH));
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testTool = new TestTool();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.testTool = null;
    }

    private class TestTool
    extends AbstractTool {
        final Phase localPH = Phase.createPhase();
        boolean finished;

        private TestTool() {
        }

        public Object getPhase() {
            return null;
        }

        public boolean destringizeConfiguration(String stringizedForm) {
            return true;
        }

        public void initialize() {
        }

        public void reset() {
        }

        public String stringizeConfiguration() {
            return null;
        }

        protected void execute(Phase phase, Phase lastPhase) throws InterruptedException {
            Thread.sleep(600L);
            this.movingToNextPhase();
            Thread.sleep(600L);
            this.localPH.nextMajorPhase();
            this.finished = true;
        }
    }
}

