/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools;

import edu.ksu.cis.indus.tools.IToolConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToolConfiguration
implements IToolConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractToolConfiguration.class);
    protected final Map<Comparable<?>, Object> properties = new HashMap();
    protected final Collection<Object> propertyIds = new HashSet<Object>();
    private String configName;

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public final Object getProperty(Comparable<?> id) {
        return this.properties.get(id);
    }

    @Override
    public void setConfigName(String string) {
        this.configName = string;
    }

    @Override
    public final boolean setProperty(Comparable<?> propertyID, Object value) {
        if (!this.propertyIds.contains(propertyID)) {
            String _message = "Invalid property identifier specified: " + propertyID;
            LOGGER.error(_message);
            throw new IllegalArgumentException(_message);
        }
        boolean _result = this.processProperty(propertyID, value);
        if (_result) {
            this.properties.put(propertyID, value);
        }
        return _result;
    }

    protected abstract boolean processProperty(Comparable<?> var1, Object var2);
}

