/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.tools;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.interfaces.AbstractStatus;
import edu.ksu.cis.indus.interfaces.IActivePart;
import edu.ksu.cis.indus.tools.CompositeToolConfiguration;
import edu.ksu.cis.indus.tools.ITool;
import edu.ksu.cis.indus.tools.IToolConfiguration;
import edu.ksu.cis.indus.tools.IToolConfigurator;
import edu.ksu.cis.indus.tools.IToolProgressListener;
import edu.ksu.cis.indus.tools.Phase;
import edu.ksu.cis.indus.tools.ToolConfigurationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTool
extends AbstractStatus
implements ITool {
    static final Logger LOGGER = LoggerFactory.getLogger(AbstractTool.class);
    protected IToolConfiguration configurationInfo;
    protected IToolConfigurator configurator;
    protected final Object control = new Object();
    Throwable childException;
    final Collection<IToolProgressListener> listeners;
    int messageId;
    boolean pause;
    Thread thread;
    int token;
    private final IActivePart.ActivePart activePart = new IActivePart.ActivePart();
    private Collection<IActivePart> activeParts = new HashSet<IActivePart>();
    private IToolConfiguration currentConfiguration;
    ExecutorService executor = Executors.newSingleThreadExecutor();

    public AbstractTool() {
        this.activeParts.add(this.activePart);
        this.listeners = Collections.synchronizedCollection(new HashSet());
    }

    @Override
    public final void abort() {
        Iterator<IActivePart> _i = this.activeParts.iterator();
        int _iEnd = this.activeParts.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            IActivePart _executor = _i.next();
            if (_executor != null) {
                this.fireToolProgressEvent("Aborting " + _executor, null);
                _executor.deactivate();
            }
            ++_iIndex;
        }
        this.resume();
    }

    @Override
    public void addToolProgressListener(IToolProgressListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final IToolConfiguration getActiveConfiguration() {
        IToolConfiguration _result = this.configurationInfo instanceof CompositeToolConfiguration ? ((CompositeToolConfiguration)this.configurationInfo).getActiveToolConfiguration() : this.configurationInfo;
        return _result;
    }

    @Override
    public Collection<IToolConfiguration> getConfigurations() {
        HashSet<IToolConfiguration> _result = new HashSet<IToolConfiguration>();
        if (this.configurationInfo instanceof CompositeToolConfiguration) {
            _result.addAll(((CompositeToolConfiguration)this.configurationInfo).configurations);
        } else {
            _result.add(this.configurationInfo);
        }
        return _result;
    }

    @Override
    public final IToolConfigurator getConfigurator() {
        return this.configurator;
    }

    public final IToolConfiguration getCurrentConfiguration() {
        return this.currentConfiguration != null ? this.currentConfiguration : this.getActiveConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void pause() {
        Object object = this.control;
        synchronized (object) {
            this.pause = true;
        }
    }

    @Override
    public void removeToolProgressListener(IToolProgressListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resume() {
        Object object = this.control;
        synchronized (object) {
            this.pause = false;
            this.control.notify();
        }
    }

    @Override
    public final synchronized void run(final Phase phase, final Phase lastPhase, boolean synchronous) {
        if (!this.pause || this.isNotAlive()) {
            this.checkConfiguration();
            this.childException = null;
            this.unstable();
            this.activateActiveParts();
            this.thread = new Thread(){

                public final void run() {
                    Throwable _temp = null;
                    try {
                        try {
                            AbstractTool.this.movingToNextPhase();
                            AbstractTool.this.execute(phase, lastPhase);
                        }
                        catch (InterruptedException _e) {
                            LOGGER.error("Interrupted while executing the tool.", (Throwable)_e);
                            _temp = _e;
                        }
                        catch (Throwable _e) {
                            LOGGER.error("Tool failed.", _e);
                            _temp = _e;
                        }
                    }
                    finally {
                        if (_temp != null) {
                            AbstractTool.this.childException = _temp;
                        }
                        AbstractTool.this.pause = false;
                        AbstractTool.this.executor.shutdown();
                        AbstractTool.this.executor = Executors.newSingleThreadExecutor();
                    }
                }
            };
            this.thread.start();
            if (synchronous) {
                try {
                    this.thread.join();
                    if (this.childException != null) {
                        throw new RuntimeException(this.childException);
                    }
                    this.stable();
                }
                catch (InterruptedException _e) {
                    LOGGER.error("Interrupted while waiting on the run to complete.", (Throwable)_e);
                    throw new RuntimeException(_e);
                }
            } else {
                Thread _temp = new Thread(){

                    public void run() {
                        try {
                            AbstractTool.this.thread.join();
                            if (AbstractTool.this.childException != null) {
                                throw new RuntimeException(AbstractTool.this.childException);
                            }
                            AbstractTool.this.stable();
                        }
                        catch (InterruptedException _e) {
                            LOGGER.error("Interrupted while waiting on the helper thread.", (Throwable)_e);
                        }
                    }
                };
                _temp.start();
            }
        } else {
            throw new IllegalStateException("run() should be called when the tool is paused or running.");
        }
    }

    protected final void addActivePart(IActivePart part) {
        this.activeParts.add(part);
    }

    @Empty
    protected void checkConfiguration() throws ToolConfigurationException {
    }

    protected abstract void execute(Phase var1, Phase var2) throws InterruptedException;

    protected void fireToolProgressEvent(final String message, final Object info) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Collection<IToolProgressListener> collection = AbstractTool.this.listeners;
                synchronized (collection) {
                    IToolProgressListener.ToolProgressEvent _evt = new IToolProgressListener.ToolProgressEvent(this, message, info);
                    for (IToolProgressListener _listener : AbstractTool.this.listeners) {
                        _listener.toolProgess(_evt);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void movingToNextPhase() throws InterruptedException {
        Object object = this.control;
        synchronized (object) {
            if (this.pause) {
                this.control.wait();
            } else if (!this.activePart.canProceed()) {
                this.fireToolProgressEvent("Tool was interrupted.", null);
            }
        }
    }

    protected final boolean removeActivePart(IActivePart part) {
        return this.activeParts.remove(part);
    }

    protected void setCurrentConfiguration(IToolConfiguration config) {
        this.currentConfiguration = config;
    }

    private void activateActiveParts() {
        Iterator<IActivePart> _i = this.activeParts.iterator();
        int _iEnd = this.activeParts.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            IActivePart _executor = _i.next();
            if (_executor != null) {
                this.fireToolProgressEvent("Activating " + _executor, null);
                _executor.activate();
            }
            ++_iIndex;
        }
    }

    private boolean isNotAlive() {
        return this.thread == null || !this.thread.isAlive();
    }
}

