/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.processing;

import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.processing.AbstractProcessingFilter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.tagkit.Host;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagBasedProcessingFilter
extends AbstractProcessingFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TagBasedProcessingFilter.class);
    protected final String tagName;

    public TagBasedProcessingFilter(String theTagName) {
        this.tagName = theTagName;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("tagName", (Object)this.tagName).toString();
    }

    @Override
    protected final Collection<SootClass> localFilterClasses(Collection<SootClass> classes) {
        return this.filter(classes);
    }

    @Override
    protected final Collection<SootField> localFilterFields(Collection<SootField> fields) {
        return this.filter(fields);
    }

    @Override
    protected final Collection<SootMethod> localFilterMethods(Collection<SootMethod> methods) {
        return this.filter(methods);
    }

    protected boolean isFilterate(Host host) {
        return host.hasTag(this.tagName);
    }

    private <T extends Host> Collection<T> filter(Collection<T> hosts) {
        ArrayList<Host> _result = new ArrayList<Host>();
        for (Host _e : hosts) {
            if (!this.isFilterate(_e)) continue;
            _result.add(_e);
        }
        if (LOGGER.isDebugEnabled() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Filtered out: " + SetUtils.difference(hosts, _result));
            LOGGER.debug("Filtrate : " + _result);
        }
        return _result;
    }
}

