/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.processing;

import edu.ksu.cis.indus.interfaces.IEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticEnvironment
implements IEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticEnvironment.class);
    private final Collection<SootClass> classes;

    public StaticEnvironment(Collection<SootClass> classesInThisEnv) {
        this.classes = new HashSet<SootClass>(classesInThisEnv);
    }

    @Override
    public SootClass getClass(String className) {
        LOGGER.error("getClass() -  : _msg = This operation is not supported by this implementation.");
        throw new UnsupportedOperationException("This operation is not supported by this implementation.");
    }

    @Override
    public Collection<SootClass> getClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }

    public Collection getRoots() {
        HashSet<SootMethod> _temp = new HashSet<SootMethod>();
        ArrayList<ArrayType> _argList = new ArrayList<ArrayType>();
        _argList.add(ArrayType.v((Type)RefType.v((String)"java.lang.String"), (int)1));
        for (SootClass _sc : this.classes) {
            SootMethod _sm = _sc.getMethod("main", _argList, (Type)VoidType.v());
            if (_sm == null || !_sm.isStatic() || !_sm.isPublic()) continue;
            _temp.add(_sm);
        }
        return null;
    }

    @Override
    public boolean hasClass(String scName) {
        Iterator<SootClass> _i = this.classes.iterator();
        int _iEnd = this.classes.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootClass _sc = _i.next();
            if (_sc.getName().equals(scName)) {
                return true;
            }
            ++_iIndex;
        }
        return false;
    }

    @Override
    public void removeClass(SootClass clazz) {
        LOGGER.error("getClass() -  : _msg = This operation is not supported by this implementation.");
        throw new UnsupportedOperationException("This operation is not supported by this implementation.");
    }
}

