/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.processing;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.interfaces.IActivePart;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UnopExpr;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingController {
    public static final Collection<Class<?>> STMT_CLASSES;
    public static final Collection<Class<?>> VALUE_CLASSES;
    private static final Logger LOGGER;
    protected final Map<Class<?>, Set<IProcessor>> class2processors = new HashMap();
    protected Context context = new Context();
    protected final Collection<IProcessor> interfaceProcessors = new ArrayList<IProcessor>();
    boolean processStmts;
    boolean processValues;
    private final IActivePart.ActivePart activePart = new IActivePart.ActivePart();
    private IEnvironment env;
    private IProcessingFilter processingFilter;
    private IStmtSequencesRetriever stmtSequencesRetriever;
    private final StmtSwitcher stmtSwitcher = new StmtSwitcher();
    private final ValueSwitcher valueSwitcher = new ValueSwitcher();

    static {
        LOGGER = LoggerFactory.getLogger(ProcessingController.class);
        HashSet<Class<XorExpr>> _t = new HashSet<Class<XorExpr>>();
        _t.add(AssignStmt.class);
        _t.add(BreakpointStmt.class);
        _t.add(EnterMonitorStmt.class);
        _t.add(ExitMonitorStmt.class);
        _t.add(GotoStmt.class);
        _t.add(IdentityStmt.class);
        _t.add(IfStmt.class);
        _t.add(InvokeStmt.class);
        _t.add(LookupSwitchStmt.class);
        _t.add(NopStmt.class);
        _t.add(RetStmt.class);
        _t.add(ReturnVoidStmt.class);
        _t.add(ReturnStmt.class);
        _t.add(TableSwitchStmt.class);
        _t.add(ThrowStmt.class);
        STMT_CLASSES = Collections.unmodifiableCollection(_t);
        _t = new HashSet();
        _t.add(AddExpr.class);
        _t.add(AndExpr.class);
        _t.add(ArrayRef.class);
        _t.add(CastExpr.class);
        _t.add(CaughtExceptionRef.class);
        _t.add(CmpExpr.class);
        _t.add(CmpgExpr.class);
        _t.add(CmplExpr.class);
        _t.add(DivExpr.class);
        _t.add(DoubleConstant.class);
        _t.add(EqExpr.class);
        _t.add(FloatConstant.class);
        _t.add(GeExpr.class);
        _t.add(GtExpr.class);
        _t.add(InstanceFieldRef.class);
        _t.add(InstanceOfExpr.class);
        _t.add(IntConstant.class);
        _t.add(InterfaceInvokeExpr.class);
        _t.add(LeExpr.class);
        _t.add(LengthExpr.class);
        _t.add(Local.class);
        _t.add(LongConstant.class);
        _t.add(LtExpr.class);
        _t.add(MulExpr.class);
        _t.add(NeExpr.class);
        _t.add(NegExpr.class);
        _t.add(NewArrayExpr.class);
        _t.add(NewExpr.class);
        _t.add(NewMultiArrayExpr.class);
        _t.add(NullConstant.class);
        _t.add(OrExpr.class);
        _t.add(ParameterRef.class);
        _t.add(RemExpr.class);
        _t.add(ShlExpr.class);
        _t.add(ShrExpr.class);
        _t.add(SpecialInvokeExpr.class);
        _t.add(StaticFieldRef.class);
        _t.add(StaticInvokeExpr.class);
        _t.add(StringConstant.class);
        _t.add(SubExpr.class);
        _t.add(ThisRef.class);
        _t.add(UshrExpr.class);
        _t.add(VirtualInvokeExpr.class);
        _t.add(XorExpr.class);
        VALUE_CLASSES = Collections.unmodifiableCollection(_t);
    }

    public final void driveProcessors(Collection<IProcessor> processors) {
        for (IProcessor _processor : processors) {
            _processor.hookup(this);
        }
        this.process();
        for (IProcessor _processor : processors) {
            _processor.unhook(this);
        }
    }

    public IActivePart getActivePart() {
        return this.activePart;
    }

    public final IEnvironment getEnvironment() {
        return this.env;
    }

    public final void process() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: processing classes");
        }
        this.initializeProcessors();
        HashSet<IProcessor> _processors = new HashSet<IProcessor>();
        _processors.addAll(this.interfaceProcessors);
        Iterator<Set<IProcessor>> _i = this.class2processors.values().iterator();
        while (_i.hasNext()) {
            _processors.addAll((Collection)_i.next());
        }
        _i = _processors.iterator();
        while (_i.hasNext()) {
            ((IProcessor)((Object)_i.next())).processingBegins();
        }
        this.processStmts = !SetUtils.intersection((Collection)this.class2processors.keySet(), STMT_CLASSES).isEmpty();
        this.processValues = !SetUtils.intersection((Collection)this.class2processors.keySet(), VALUE_CLASSES).isEmpty();
        this.processClasses(this.env.getClasses());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: processing classes");
            LOGGER.info("BEGIN: consolidation");
        }
        _i = _processors.iterator();
        while (_i.hasNext()) {
            ((IProcessor)((Object)_i.next())).consolidate();
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: consolidation");
        }
    }

    public final void register(Class<?> interest, IProcessor processor) {
        Set<IProcessor> _temp = this.class2processors.get(interest);
        if (_temp == null) {
            _temp = new HashSet<IProcessor>();
            this.class2processors.put(interest, _temp);
        }
        _temp.add(processor);
    }

    public final void register(IProcessor processor) {
        if (!this.interfaceProcessors.contains(processor)) {
            this.interfaceProcessors.add(processor);
        }
    }

    public final void registerForAllStmts(IProcessor processor) {
        Iterator<Class<?>> _i = STMT_CLASSES.iterator();
        while (_i.hasNext()) {
            this.register(_i.next(), processor);
        }
    }

    public final void registerForAllValues(IProcessor processor) {
        Iterator<Class<?>> _i = VALUE_CLASSES.iterator();
        while (_i.hasNext()) {
            this.register(_i.next(), processor);
        }
    }

    public final void reset() {
        this.class2processors.clear();
        this.interfaceProcessors.clear();
        this.processStmts = false;
        this.processValues = false;
        this.context.setStmt(null);
        this.context.setProgramPoint(null);
        this.context.setRootMethod(null);
        this.context.returnFromCurrentMethod();
        this.activePart.activate();
    }

    public final void setEnvironment(IEnvironment environment) {
        this.env = environment;
    }

    public final void setProcessingFilter(IProcessingFilter theFilter) {
        this.processingFilter = theFilter;
    }

    public void setStmtSequencesRetriever(IStmtSequencesRetriever retriever) {
        this.stmtSequencesRetriever = retriever;
    }

    public final void unregister(Class<?> interest, IProcessor processor) {
        Set<IProcessor> _temp = this.class2processors.get(interest);
        if (_temp == null) {
            throw new IllegalArgumentException("There are no processors registered  for " + interest.getName());
        }
        _temp.remove(processor);
    }

    public final void unregister(IProcessor processor) {
        this.interfaceProcessors.remove(processor);
    }

    public final void unregisterForAllStmts(IProcessor processor) {
        Iterator<Class<?>> _i = STMT_CLASSES.iterator();
        while (_i.hasNext()) {
            this.unregister(_i.next(), processor);
        }
    }

    public final void unregisterForAllValues(IProcessor processor) {
        Iterator<Class<?>> _i = VALUE_CLASSES.iterator();
        while (_i.hasNext()) {
            this.unregister(_i.next(), processor);
        }
    }

    @Empty
    protected void initializeProcessors() {
    }

    void processValueBoxes(Collection<ValueBox> boxes) {
        if (this.processingFilter != null) {
            this.processingFilter.filterValueBoxes(boxes);
        }
        Iterator<ValueBox> _i = boxes.iterator();
        int _iEnd = boxes.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            ValueBox _vb = _i.next();
            this.context.setProgramPoint(_vb);
            _vb.getValue().apply((Switch)this.valueSwitcher);
            ++_iIndex;
        }
    }

    private void processClasses(Collection<SootClass> theClasses) {
        Collection<SootClass> _classes;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("processClasses(Collection) - BEGIN");
        }
        if (this.processingFilter == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Performance may be hit as processing filter is not set.");
            }
            _classes = theClasses;
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing filter class: " + this.processingFilter);
            }
            _classes = this.processingFilter.filterClasses(theClasses);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Classes NOT to be processed:\n" + SetUtils.difference(theClasses, _classes));
            LOGGER.debug("Classes to be processed:\n" + _classes);
        }
        Iterator<SootClass> _i = _classes.iterator();
        while (_i.hasNext() && this.activePart.canProceed()) {
            SootClass _sc = _i.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing class " + _sc);
            }
            for (IProcessor _pp : this.interfaceProcessors) {
                _pp.callback(_sc);
                Object _fields = this.processingFilter == null ? _sc.getFields() : this.processingFilter.filterFields((Collection<SootField>)_sc.getFields());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Fields NOT to be processed:\n" + SetUtils.difference(_sc.getFields(), _fields));
                    LOGGER.debug("Fields to be processed:\n" + _fields);
                }
                Iterator _j = _fields.iterator();
                while (_j.hasNext()) {
                    _pp.callback((SootField)_j.next());
                }
            }
            this.processMethods(_sc.getMethods());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("processClasses(Collection) - END");
        }
    }

    private void processMethodBody(SootMethod method) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing method " + method);
        }
        if (this.stmtSequencesRetriever == null) {
            LOGGER.error("Please call setStmtSequenceRetriever() with a non-null argument before executing the controller.");
            throw new IllegalStateException("Please call setStmtSequenceRetriever() with a non-null argument before executing the controller.");
        }
        try {
            Collection<List<Stmt>> _col1 = this.stmtSequencesRetriever.retrieveStmtSequences(method);
            Iterator<List<Stmt>> _j = _col1.iterator();
            int _jEnd = _col1.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd && this.activePart.canProceed()) {
                Collection<Stmt> _seq = this.processingFilter != null ? this.processingFilter.filterStmts((Collection<Stmt>)_j.next()) : (Collection<Stmt>)_j.next();
                Iterator _i = _seq.iterator();
                int _iEnd = _seq.size();
                int _iIndex = 0;
                while (_iIndex < _iEnd && this.activePart.canProceed()) {
                    Stmt _stmt = (Stmt)_i.next();
                    this.context.setStmt(_stmt);
                    _stmt.apply((Switch)this.stmtSwitcher);
                    ++_iIndex;
                }
                ++_jIndex;
            }
        }
        catch (RuntimeException _e) {
            LOGGER.error("Well, exception while processing statements of a method may mean the processor does not recognize the given method or it's parts or method has not stored in jimple representation. : " + method.getSignature(), (Throwable)_e);
        }
    }

    private void processMethods(Collection<SootMethod> theMethods) {
        Collection<SootMethod> _methods = this.processingFilter == null ? theMethods : this.processingFilter.filterMethods(theMethods);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Methods NOT to be processed:\n" + SetUtils.difference(theMethods, _methods));
            LOGGER.debug("Methods to be processed:\n" + _methods);
        }
        boolean _processBody = this.processStmts || this.processValues;
        Iterator<SootMethod> _j = _methods.iterator();
        while (_j.hasNext() && this.activePart.canProceed()) {
            SootMethod _sm = _j.next();
            this.context.setRootMethod(_sm);
            Iterator<IProcessor> _k = this.interfaceProcessors.iterator();
            while (_k.hasNext()) {
                _k.next().callback(_sm);
            }
            if (_processBody && _sm.isConcrete()) {
                this.processMethodBody(_sm);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(_sm + " is not a concrete method.  Hence, it's body could not be retrieved.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StmtSwitcher
    extends AbstractStmtSwitch {
        public void caseAssignStmt(AssignStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(AssignStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                this.processValuesBoxesInDefStmt((DefinitionStmt)stmt);
            }
        }

        public void caseBreakpointStmt(BreakpointStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(BreakpointStmt.class, (Stmt)stmt);
            }
        }

        public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(EnterMonitorStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(stmt.getOpBox()));
            }
        }

        public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(ExitMonitorStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(stmt.getOpBox()));
            }
        }

        public void caseGotoStmt(GotoStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(GotoStmt.class, (Stmt)stmt);
            }
        }

        public void caseIdentityStmt(IdentityStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(IdentityStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                this.processValuesBoxesInDefStmt((DefinitionStmt)stmt);
            }
        }

        public void caseIfStmt(IfStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(IfStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(stmt.getConditionBox()));
            }
        }

        public void caseInvokeStmt(InvokeStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(InvokeStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(stmt.getInvokeExprBox()));
            }
        }

        public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(LookupSwitchStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(stmt.getKeyBox()));
            }
        }

        public void caseNopStmt(NopStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(NopStmt.class, (Stmt)stmt);
            }
        }

        public void caseRetStmt(RetStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(RetStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(stmt.getStmtAddressBox()));
            }
        }

        public void caseReturnStmt(ReturnStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(ReturnStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(stmt.getOpBox()));
            }
        }

        public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(ReturnVoidStmt.class, (Stmt)stmt);
            }
        }

        public void caseTableSwitchStmt(TableSwitchStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(TableSwitchStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(stmt.getKeyBox()));
            }
        }

        public void caseThrowStmt(ThrowStmt stmt) {
            if (ProcessingController.this.processStmts) {
                this.defaultCase(ThrowStmt.class, (Stmt)stmt);
            }
            if (ProcessingController.this.processValues) {
                ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(stmt.getOpBox()));
            }
        }

        public void defaultCase(Class<?> objClass, Stmt o) {
            Collection _temp = ProcessingController.this.class2processors.get(objClass);
            if (_temp != null) {
                Stmt _stmt = o;
                for (IProcessor _pp : _temp) {
                    _pp.callback(_stmt, ProcessingController.this.context);
                }
            }
        }

        private void processValuesBoxesInDefStmt(DefinitionStmt stmt) {
            ArrayList<ValueBox> _boxes = new ArrayList<ValueBox>();
            _boxes.add(stmt.getLeftOpBox());
            _boxes.add(stmt.getRightOpBox());
            ProcessingController.this.processValueBoxes(_boxes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueSwitcher
    extends AbstractJimpleValueSwitch {
        public void caseAddExpr(AddExpr v) {
            this.defaultCase(AddExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseAndExpr(AndExpr v) {
            this.defaultCase(AndExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseArrayRef(ArrayRef v) {
            this.defaultCase(ArrayRef.class);
            ArrayList<ValueBox> _boxes = new ArrayList<ValueBox>();
            _boxes.add(v.getBaseBox());
            _boxes.add(v.getIndexBox());
            ProcessingController.this.processValueBoxes(_boxes);
        }

        public void caseCastExpr(CastExpr v) {
            this.defaultCase(CastExpr.class);
            ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(v.getOpBox()));
        }

        public void caseCaughtExceptionRef(CaughtExceptionRef v) {
            this.defaultCase(CaughtExceptionRef.class);
        }

        public void caseCmpExpr(CmpExpr v) {
            this.defaultCase(CmpExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseCmpgExpr(CmpgExpr v) {
            this.defaultCase(CmpgExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseCmplExpr(CmplExpr v) {
            this.defaultCase(CmplExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseDivExpr(DivExpr v) {
            this.defaultCase(DivExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseDoubleConstant(DoubleConstant v) {
            this.defaultCase(DoubleConstant.class);
        }

        public void caseEqExpr(EqExpr v) {
            this.defaultCase(EqExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseFloatConstant(FloatConstant v) {
            this.defaultCase(FloatConstant.class);
        }

        public void caseGeExpr(GeExpr v) {
            this.defaultCase(GeExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseGtExpr(GtExpr v) {
            this.defaultCase(GtExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseInstanceFieldRef(InstanceFieldRef v) {
            this.defaultCase(InstanceFieldRef.class);
            ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(v.getBaseBox()));
        }

        public void caseInstanceOfExpr(InstanceOfExpr v) {
            this.defaultCase(InstanceOfExpr.class);
            ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(v.getOpBox()));
        }

        public void caseIntConstant(IntConstant v) {
            this.defaultCase(IntConstant.class);
        }

        public void caseInterfaceInvokeExpr(InterfaceInvokeExpr v) {
            this.defaultCase(InterfaceInvokeExpr.class);
            this.processInvokeExpr((InvokeExpr)v);
        }

        public void caseLeExpr(LeExpr v) {
            this.defaultCase(LeExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseLengthExpr(LengthExpr v) {
            this.defaultCase(LengthExpr.class);
            this.processUnaryExpr((UnopExpr)v);
        }

        public void caseLocal(Local v) {
            this.defaultCase(Local.class);
        }

        public void caseLongConstant(LongConstant v) {
            this.defaultCase(LongConstant.class);
        }

        public void caseLtExpr(LtExpr v) {
            this.defaultCase(LtExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseMulExpr(MulExpr v) {
            this.defaultCase(MulExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseNeExpr(NeExpr v) {
            this.defaultCase(NeExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseNegExpr(NegExpr v) {
            this.defaultCase(NegExpr.class);
            this.processUnaryExpr((UnopExpr)v);
        }

        public void caseNewArrayExpr(NewArrayExpr v) {
            this.defaultCase(NewArrayExpr.class);
            ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(v.getSizeBox()));
        }

        public void caseNewExpr(NewExpr v) {
            this.defaultCase(NewExpr.class);
        }

        public void caseNewMultiArrayExpr(NewMultiArrayExpr v) {
            this.defaultCase(NewMultiArrayExpr.class);
            ArrayList<ValueBox> _boxes = new ArrayList<ValueBox>();
            int _i = 0;
            while (_i < v.getSizeCount()) {
                _boxes.add(v.getSizeBox(_i));
                ++_i;
            }
            ProcessingController.this.processValueBoxes(_boxes);
        }

        public void caseNullConstant(NullConstant v) {
            this.defaultCase(NullConstant.class);
        }

        public void caseOrExpr(OrExpr v) {
            this.defaultCase(OrExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseParameterRef(ParameterRef v) {
            this.defaultCase(ParameterRef.class);
        }

        public void caseRemExpr(RemExpr v) {
            this.defaultCase(RemExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseShlExpr(ShlExpr v) {
            this.defaultCase(ShlExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseShrExpr(ShrExpr v) {
            this.defaultCase(ShrExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseSpecialInvokeExpr(SpecialInvokeExpr v) {
            this.defaultCase(SpecialInvokeExpr.class);
            this.processInvokeExpr((InvokeExpr)v);
        }

        public void caseStaticFieldRef(StaticFieldRef v) {
            this.defaultCase(StaticFieldRef.class);
        }

        public void caseStaticInvokeExpr(StaticInvokeExpr v) {
            this.defaultCase(StaticInvokeExpr.class);
            this.processInvokeExpr((InvokeExpr)v);
        }

        public void caseStringConstant(StringConstant v) {
            this.defaultCase(StringConstant.class);
        }

        public void caseSubExpr(SubExpr v) {
            this.defaultCase(SubExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseThisRef(ThisRef v) {
            this.defaultCase(ThisRef.class);
        }

        public void caseUshrExpr(UshrExpr v) {
            this.defaultCase(UshrExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void caseVirtualInvokeExpr(VirtualInvokeExpr v) {
            this.defaultCase(VirtualInvokeExpr.class);
            this.processInvokeExpr((InvokeExpr)v);
        }

        public void caseXorExpr(XorExpr v) {
            this.defaultCase(XorExpr.class);
            this.processBinaryExpr((BinopExpr)v);
        }

        public void defaultCase(Class<?> objClass) {
            Collection _temp = ProcessingController.this.class2processors.get(objClass);
            if (_temp != null) {
                ValueBox _programPoint = ProcessingController.this.context.getProgramPoint();
                for (IProcessor _pp : _temp) {
                    _pp.callback(_programPoint, ProcessingController.this.context);
                }
            }
        }

        private void processBinaryExpr(BinopExpr v) {
            ArrayList<ValueBox> _boxes = new ArrayList<ValueBox>();
            _boxes.add(v.getOp1Box());
            _boxes.add(v.getOp2Box());
            ProcessingController.this.processValueBoxes(_boxes);
        }

        private void processInvokeExpr(InvokeExpr v) {
            ArrayList<ValueBox> _boxes = new ArrayList<ValueBox>();
            if (v instanceof InstanceInvokeExpr) {
                _boxes.add(((InstanceInvokeExpr)v).getBaseBox());
            }
            int _i = 0;
            while (_i < v.getArgCount()) {
                _boxes.add(v.getArgBox(_i));
                ++_i;
            }
            ProcessingController.this.processValueBoxes(_boxes);
        }

        private void processUnaryExpr(UnopExpr v) {
            ProcessingController.this.processValueBoxes((Collection<ValueBox>)Collections.singletonList(v.getOpBox()));
        }
    }
}

