/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.processing;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.common.collections.IteratorUtils;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.processing.AbstractStmtSequenceRetriever;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OneAllStmtSequenceRetriever
extends AbstractStmtSequenceRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneAllStmtSequenceRetriever.class);

    @Empty
    public OneAllStmtSequenceRetriever() {
    }

    @Override
    public Collection<List<Stmt>> retrieveStmtSequences(SootMethod method) {
        ArrayList<Stmt> _temp = new ArrayList<Stmt>();
        ArrayList<List<Stmt>> _result = new ArrayList<List<Stmt>>();
        _result.add(_temp);
        BasicBlockGraphMgr _bbgMgr = this.getBbgFactory();
        if (_bbgMgr != null) {
            BasicBlockGraph _bbg = _bbgMgr.getBasicBlockGraph(method);
            Iterator _i = _bbg.getNodes().iterator();
            int _iEnd = _bbg.getNodes().size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_i.next();
                _temp.addAll(_bb.getStmtsOf());
                ++_iIndex;
            }
        } else {
            IStmtGraphFactory<?> _sgf = this.getStmtGraphFactory();
            if (_sgf != null) {
                Object _sg = _sgf.getStmtGraph(method);
                _temp.addAll(IteratorUtils.toList(_sg.iterator()));
            } else {
                LOGGER.error("Please provide a statement graph factory or a basic block graph manager.");
                throw new IllegalStateException("Please provide a statement graph factory or a basic block graph manager.");
            }
        }
        return _result;
    }
}

