/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.processing;

import edu.ksu.cis.indus.interfaces.IEnvironment;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import soot.ArrayType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Environment
implements IEnvironment {
    private final Scene system;

    public Environment(Scene scene) {
        this.system = scene;
    }

    @Override
    public SootClass getClass(String className) {
        if (!this.system.containsClass(className)) {
            this.system.loadClassAndSupport(className);
        }
        return this.system.getSootClass(className);
    }

    @Override
    public Collection<SootClass> getClasses() {
        return this.system.getClasses();
    }

    @Override
    public Collection<SootMethod> getRoots() {
        HashSet<SootMethod> _temp = new HashSet<SootMethod>();
        List<ArrayType> _argList = Collections.singletonList(ArrayType.v((Type)RefType.v((String)"java.lang.String"), (int)1));
        for (SootClass _sc : this.getClasses()) {
            SootMethod _sm = _sc.getMethod("main", _argList, (Type)VoidType.v());
            if (_sm == null || !_sm.isStatic() || !_sm.isPublic()) continue;
            _temp.add(_sm);
        }
        return _temp;
    }

    @Override
    public boolean hasClass(String scName) {
        return this.system.containsClass(scName);
    }

    @Override
    public void removeClass(SootClass clazz) {
        this.system.removeClass(clazz);
    }
}

