/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.processing;

import java.util.EmptyStackException;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Context.class);
    protected Stack<SootMethod> callString = new Stack();
    protected Stmt stmt;
    protected ValueBox progPoint;

    public final Stack<SootMethod> getCallString() {
        Stack<SootMethod> _temp = new Stack<SootMethod>();
        _temp.addAll(this.callString);
        return _temp;
    }

    public final SootMethod getCurrentMethod() {
        SootMethod _result;
        block2: {
            _result = null;
            try {
                _result = this.callString.peek();
            }
            catch (EmptyStackException _e) {
                if (!LOGGER.isInfoEnabled()) break block2;
                LOGGER.info("There are no methods in the call stack.", (Throwable)_e);
            }
        }
        return _result;
    }

    public final ValueBox setProgramPoint(ValueBox pp) {
        ValueBox _temp = this.progPoint;
        this.progPoint = pp;
        return _temp;
    }

    public final ValueBox getProgramPoint() {
        return this.progPoint;
    }

    public final void setRootMethod(SootMethod sm) {
        this.callString.removeAllElements();
        this.callString.push(sm);
    }

    public final Stmt setStmt(Stmt stmtParam) {
        Stmt _temp = this.stmt;
        this.stmt = stmtParam;
        return _temp;
    }

    public final Stmt getStmt() {
        return this.stmt;
    }

    public final void callNewMethod(SootMethod sm) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding method " + sm);
        }
        this.callString.push(sm);
    }

    public Context clone() {
        Context _temp = null;
        try {
            _temp = (Context)super.clone();
            _temp.callString = (Stack)this.callString.clone();
        }
        catch (CloneNotSupportedException _e) {
            LOGGER.error("This should not happen.", (Throwable)_e);
        }
        return _temp;
    }

    public boolean equals(Object o) {
        boolean _ret = false;
        if (o != null && o instanceof Context) {
            Context _temp = (Context)o;
            boolean bl = _ret = this == o || this.progPoint == _temp.progPoint;
            if (_ret) {
                boolean bl2 = _ret = this.stmt == _temp.stmt;
                if (_ret) {
                    _ret = this.callString == _temp.callString || this.callString != null && this.callString.equals(_temp.callString);
                }
            }
        }
        return _ret;
    }

    public int hashCode() {
        int _result = 17;
        if (this.progPoint != null) {
            _result = 37 * _result + this.progPoint.hashCode();
        }
        if (this.stmt != null) {
            _result = 37 * _result + this.stmt.hashCode();
        }
        _result = 37 * _result + this.callString.hashCode();
        return _result;
    }

    public final SootMethod returnFromCurrentMethod() {
        return this.callString.pop();
    }

    public String toString() {
        return "Context:\n\tProgram Point: " + this.progPoint + "\n\tStmt: " + this.stmt + "\n\tCallStack: " + this.callString + "\n";
    }
}

