/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.interfaces;

import edu.ksu.cis.indus.interfaces.IPoolable;
import org.apache.commons.pool.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPoolable
implements IPoolable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPoolable.class);
    private ObjectPool pool;

    public void returnToPool() {
        if (this.pool != null) {
            try {
                this.pool.returnObject((Object)this);
            }
            catch (Exception _e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("How can this happen?", (Throwable)_e);
                }
                throw new RuntimeException(_e);
            }
        }
    }

    public final void setPool(ObjectPool thePool) {
        if (thePool == null) {
            throw new IllegalArgumentException("Invalid argument: null");
        }
        this.pool = thePool;
    }
}

