/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.interfaces;

import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.interfaces.AbstractIDBasedInfoManagement;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.ICallingContextRetriever;
import edu.ksu.cis.indus.processing.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCallingContextRetriever
extends AbstractIDBasedInfoManagement
implements ICallingContextRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCallingContextRetriever.class);
    private final int callContextLenLimit;
    private ICallGraphInfo callGraph;
    private final Collection<Pair<ICallGraphInfo.CallTriple, Object>> exploredCallSites = new HashSet<Pair<ICallGraphInfo.CallTriple, Object>>();

    public AbstractCallingContextRetriever(int callingContextLengthLimit) {
        if (callingContextLengthLimit < 0) {
            throw new IllegalArgumentException("callStackLengthLimit has to be a positive integer - " + callingContextLengthLimit);
        }
        this.callContextLenLimit = callingContextLengthLimit;
    }

    @Override
    public final Collection<Stack<ICallGraphInfo.CallTriple>> getCallingContextsForProgramPoint(Context context) {
        SootMethod _currentMethod = context.getCurrentMethod();
        Collection<Object> _result = this.considerProgramPoint(context) ? (this.callContextLenLimit == 0 ? NULL_CONTEXTS : this.getCallingContexts(this.getTokenForProgramPoint(context), _currentMethod)) : (Collection<Stack<ICallGraphInfo.CallTriple>>)Collections.emptySet();
        return _result;
    }

    @Override
    public final Collection<Stack<ICallGraphInfo.CallTriple>> getCallingContextsForThis(Context methodContext) {
        Collection<Object> _result = this.considerThis(methodContext) ? (this.callContextLenLimit == 0 ? NULL_CONTEXTS : this.getCallingContexts(this.getTokenForThis(methodContext), methodContext.getCurrentMethod())) : (Collection<Stack<ICallGraphInfo.CallTriple>>)Collections.emptySet();
        return _result;
    }

    public final void setCallGraph(ICallGraphInfo cgi) {
        this.callGraph = cgi;
    }

    protected boolean considerProgramPoint(Context programPointContext) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("considerProgramPoint(programPointContext = " + programPointContext + ")");
        }
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    protected boolean considerThis(Context methodContext) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("considerThis(methodContext = " + methodContext + ")");
        }
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    protected Object getCallerSideToken(Object token, SootMethod callee, ICallGraphInfo.CallTriple callsite, Stack<ICallGraphInfo.CallTriple> calleeCallStack) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("getCallerSideToken(token = " + token + ", callee = " + callee + ", callsite = " + callsite + ")");
        }
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    protected final ICallGraphInfo getCallGraph() {
        return this.callGraph;
    }

    protected Object getTokenForProgramPoint(Context programPointContext) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("getTokenForProgramPoint(programPointContext = " + programPointContext + ")");
        }
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    protected Object getTokenForThis(Context methodContext) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("getTokenForThis(methodContext = " + methodContext + ")");
        }
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    void calculateCallStack(@NonNull @Immutable SootMethod callee, @NonNull @Immutable Object calleeToken, @NonNull @Immutable Stack<ICallGraphInfo.CallTriple> calleeCallStack, IWorkBag<Triple<SootMethod, Object, Stack<ICallGraphInfo.CallTriple>>> wb, Collection<Stack<ICallGraphInfo.CallTriple>> result) {
        if (calleeCallStack.size() == this.callContextLenLimit) {
            result.add(calleeCallStack);
        } else {
            Collection<ICallGraphInfo.CallTriple> _callers = this.callGraph.getCallers(callee);
            int _jEnd = _callers.size();
            if (_jEnd == 0 && calleeCallStack.size() < this.callContextLenLimit) {
                result.add(calleeCallStack);
            } else {
                Iterator<ICallGraphInfo.CallTriple> _j = _callers.iterator();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    ICallGraphInfo.CallTriple _callSite = _j.next();
                    if (this.isCallSiteExplored(_callSite, calleeToken)) {
                        Object _callerStack;
                        Object _callerToken = this.getCallerSideToken(calleeToken, callee, _callSite, calleeCallStack);
                        if (_callerToken == Tokens.DISCARD_CONTEXT_TOKEN) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Discarding context " + calleeToken + "   " + this.getClass());
                            }
                        } else if (_callerToken == Tokens.ACCEPT_TERMINAL_CONTEXT_TOKEN || _callerToken == Tokens.ACCEPT_NON_TERMINAL_CONTEXT_TOKEN) {
                            _callerStack = calleeCallStack.clone();
                            ((Stack)_callerStack).push(_callSite);
                            if (_callerToken == Tokens.ACCEPT_TERMINAL_CONTEXT_TOKEN) {
                                ((Stack)_callerStack).push(null);
                            }
                            result.add((Stack<ICallGraphInfo.CallTriple>)_callerStack);
                        } else {
                            _callerStack = calleeCallStack.clone();
                            ((Stack)_callerStack).push(_callSite);
                            wb.addWorkNoDuplicates(new Triple<SootMethod, Object, Object>(_callSite.getMethod(), _callerToken, _callerStack));
                        }
                    } else {
                        Object _callerStack = calleeCallStack.clone();
                        ((Stack)_callerStack).push(_callSite);
                        ((Stack)_callerStack).push(null);
                        result.add((Stack<ICallGraphInfo.CallTriple>)_callerStack);
                    }
                    ++_jIndex;
                }
            }
        }
    }

    private Collection<Stack<ICallGraphInfo.CallTriple>> getCallingContexts(Object token, SootMethod method) {
        HashSet<Stack<ICallGraphInfo.CallTriple>> _result;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getCallingContexts(Object token = " + token + ", SootMethod method = " + method + ") - BEGIN");
        }
        if (token == Tokens.CONSIDER_ALL_CONTEXTS_TOKEN) {
            _result = ICallingContextRetriever.NULL_CONTEXTS;
        } else if (token != Tokens.DISCARD_CONTEXT_TOKEN) {
            LIFOWorkBag<Triple<SootMethod, Object, Stack<ICallGraphInfo.CallTriple>>> _wb = new LIFOWorkBag<Triple<SootMethod, Object, Stack<ICallGraphInfo.CallTriple>>>();
            _wb.addWork(new Triple(method, token, new Stack()));
            _result = new HashSet<Stack<ICallGraphInfo.CallTriple>>();
            while (_wb.hasWork()) {
                Triple _triple = (Triple)_wb.getWork();
                SootMethod _callee = (SootMethod)_triple.getFirst();
                Object _calleeToken = _triple.getSecond();
                Stack _calleeCallStack = (Stack)_triple.getThird();
                this.calculateCallStack(_callee, _calleeToken, _calleeCallStack, _wb, _result);
            }
            Iterator _j = _result.iterator();
            int _jEnd = _result.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                Stack _stack = (Stack)_j.next();
                if (_stack != null) {
                    Collections.reverse(_stack);
                }
                ++_jIndex;
            }
        } else {
            _result = (HashSet<Stack<ICallGraphInfo.CallTriple>>)Collections.emptySet();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getCallingContexts() - END - return value = " + _result);
        }
        return _result;
    }

    boolean isCallSiteExplored(@NonNull @Immutable ICallGraphInfo.CallTriple callSite, @NonNull @Immutable Object calleeToken) {
        Pair<ICallGraphInfo.CallTriple, Object> _pair = new Pair<ICallGraphInfo.CallTriple, Object>(callSite, calleeToken, true, false);
        return this.exploredCallSites.add(_pair);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Tokens {
        ACCEPT_NON_TERMINAL_CONTEXT_TOKEN,
        ACCEPT_TERMINAL_CONTEXT_TOKEN,
        CONSIDER_ALL_CONTEXTS_TOKEN,
        DISCARD_CONTEXT_TOKEN;

    }
}

