/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.processing.Environment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;

public class UtilTest
extends IndusTestCase {
    private static Scene scene;
    private static SootClass sc;
    private static final int NUMBER_OF_TESTS = 12;
    private static int count;

    public final void testFindMethodInSuperClassesAndInterfaces() {
        Collection<SootMethod> _temp = Util.findMethodInSuperClassesAndInterfaces(sc.getMethodByName("add"));
        UtilTest.assertFalse((boolean)_temp.isEmpty());
        ArrayList<RefType> _params = new ArrayList<RefType>();
        _params.add(scene.loadClassAndSupport("java.lang.Object").getType());
        UtilTest.assertTrue((boolean)_temp.contains(scene.loadClassAndSupport("java.util.Collection").getMethod("add", _params)));
        UtilTest.assertFalse((boolean)_temp.isEmpty());
    }

    public final void testFixupThreadStartBody() {
        SootClass _thread = scene.loadClassAndSupport("java.lang.Thread");
        Util.fixupThreadStartBody(scene);
        SootMethod _sm = _thread.getMethodByName("start");
        UtilTest.assertFalse((boolean)_sm.isNative());
        UtilTest.assertTrue((_sm.getActiveBody() != null ? 1 : 0) != 0);
        UtilTest.assertTrue((boolean)_sm.isConcrete());
    }

    public final void testGetAncestors() {
        Collection<SootClass> _classes = Util.getAncestors(sc);
        ArrayList<String> _ancestors = new ArrayList<String>();
        _ancestors.add("java.lang.Object");
        _ancestors.add("java.util.Collection");
        _ancestors.add("java.util.Set");
        _ancestors.add("java.lang.Cloneable");
        _ancestors.add("java.io.Serializable");
        _ancestors.add("java.util.AbstractSet");
        _ancestors.add("java.util.AbstractCollection");
        _ancestors.add("java.lang.Iterable");
        UtilTest.assertEquals((int)_ancestors.size(), (int)_classes.size());
        for (SootClass _class : _classes) {
            _ancestors.remove(_class.getName());
        }
        UtilTest.assertTrue((boolean)_ancestors.isEmpty());
    }

    public final void testGetDeclaringClass() {
        SootClass _sc = Util.getDeclaringClass(sc, "notify", Collections.EMPTY_LIST, (Type)VoidType.v());
        UtilTest.assertTrue((boolean)_sc.getName().equals("java.lang.Object"));
    }

    public final void testGetDefaultValueFor() {
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)IntType.v()).equals(IntConstant.v((int)0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)FloatType.v()).equals(FloatConstant.v((float)0.0f)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)DoubleType.v()).equals(DoubleConstant.v((double)0.0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)CharType.v()).equals(IntConstant.v((int)0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)BooleanType.v()).equals(IntConstant.v((int)0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)ByteType.v()).equals(IntConstant.v((int)0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)LongType.v()).equals(LongConstant.v((long)0L)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)ShortType.v()).equals(IntConstant.v((int)0)));
        UtilTest.assertTrue((boolean)Util.getDefaultValueFor((Type)ArrayType.v((Type)CharType.v(), (int)2)).equals(NullConstant.v()));
    }

    public final void testImplementsInterface() {
        UtilTest.assertTrue((boolean)Util.implementsInterface(sc, "java.util.Collection"));
        UtilTest.assertFalse((boolean)Util.implementsInterface(sc, "java.text.CharacterIterator"));
    }

    public final void testIsDescendentOfSootClassSootClass() {
        UtilTest.assertTrue((boolean)Util.isDescendentOf(sc, scene.getSootClass("java.util.AbstractSet")));
        UtilTest.assertFalse((boolean)Util.isDescendentOf(scene.getSootClass("java.util.AbstractSet"), sc));
        UtilTest.assertFalse((boolean)Util.isDescendentOf(sc, scene.loadClassAndSupport("java.util.AbstractList")));
    }

    public final void testIsDescendentOfSootClassString() {
        UtilTest.assertTrue((boolean)Util.isDescendentOf(sc, "java.util.AbstractSet"));
        UtilTest.assertFalse((boolean)Util.isDescendentOf(sc, "java.util.AbstractList"));
    }

    public final void testIsHierarchicallyRelated() {
        UtilTest.assertTrue((boolean)Util.isHierarchicallyRelated(sc, scene.getSootClass("java.util.AbstractSet")));
        UtilTest.assertFalse((boolean)Util.isHierarchicallyRelated(sc, scene.loadClassAndSupport("java.util.AbstractList")));
        UtilTest.assertTrue((boolean)Util.isHierarchicallyRelated(scene.getSootClass("java.util.AbstractSet"), sc));
    }

    public final void testIsSameOrSubType() {
        Environment _env = new Environment(scene);
        UtilTest.assertTrue((boolean)Util.isSameOrSubType((Type)sc.getType(), (Type)scene.getSootClass("java.util.AbstractSet").getType(), _env));
        UtilTest.assertFalse((boolean)Util.isSameOrSubType((Type)scene.getSootClass("java.util.AbstractSet").getType(), (Type)sc.getType(), _env));
        UtilTest.assertFalse((boolean)Util.isSameOrSubType((Type)sc.getType(), (Type)scene.loadClassAndSupport("java.util.AbstractList").getType(), _env));
        UtilTest.assertFalse((boolean)Util.isSameOrSubType((Type)scene.getSootClass("java.util.AbstractList").getType(), (Type)sc.getType(), _env));
    }

    public final void testRemoveMethodsWithSameSignature() {
        SootClass _object = scene.getSootClass("java.lang.Object");
        ArrayList<Object> _t1 = new ArrayList<SootMethod>(sc.getMethods());
        int _preSize = _t1.size();
        Util.removeMethodsWithSameSignature(_t1, _object.getMethods());
        UtilTest.assertTrue((_t1.size() == _preSize - 3 ? 1 : 0) != 0);
        _t1 = new ArrayList(_object.getMethods());
        _preSize = _t1.size();
        Util.removeMethodsWithSameSignature(_t1, _object.getMethods());
        UtilTest.assertTrue((_t1.size() != _preSize ? 1 : 0) != 0);
        UtilTest.assertTrue((boolean)_t1.isEmpty());
    }

    public final void testRetainMethodsWithSameSignature() {
        SootClass _object = scene.getSootClass("java.lang.Object");
        ArrayList<Object> _t1 = new ArrayList<SootMethod>(sc.getMethods());
        int _preSize = _t1.size();
        Util.retainMethodsWithSameSignature(_t1, _object.getMethods());
        UtilTest.assertTrue((_t1.size() != _preSize ? 1 : 0) != 0);
        UtilTest.assertTrue((_t1.size() == 3 ? 1 : 0) != 0);
        _t1 = new ArrayList(_object.getMethods());
        _preSize = _t1.size();
        Util.retainMethodsWithSameSignature(_t1, _object.getMethods());
        UtilTest.assertTrue((_t1.size() == _preSize ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        if (scene == null) {
            scene = Scene.v();
            sc = scene.loadClassAndSupport("java.util.HashSet");
        }
    }

    protected void tearDown() throws Exception {
        if (++count == 12) {
            G.reset();
            scene = null;
        }
    }
}

