/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.soot.ClassEraser;
import edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PatchingChain;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Value;
import soot.VoidType;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.tagkit.Host;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);

    @Empty
    private Util() {
    }

    @NonNullContainer
    @NonNull
    @Immutable
    public static Collection<SootClass> eraseClassesFrom(@Immutable @NonNull @NonNullContainer Collection<SootClass> classes, @NonNull IEnvironment env) {
        ArrayList<SootClass> _result = new ArrayList<SootClass>(classes);
        ProcessingController _pc = new ProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(new CompleteStmtGraphFactory());
        _pc.setStmtSequencesRetriever(_ssr);
        _pc.setEnvironment(env);
        ClassEraser _ece = new ClassEraser(_result);
        _ece.hookup(_pc);
        _pc.process();
        _ece.unhook(_pc);
        _pc.reset();
        Iterator<SootClass> _j = classes.iterator();
        int _jEnd = classes.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            SootClass _o = _j.next();
            if (_result.contains(_o)) {
                env.removeClass(_o);
            }
            ++_jIndex;
        }
        return _result;
    }

    @Functional
    @NonNull
    public static SootMethod findDeclaringMethod(@NonNull SootClass sc, @NonNull SootMethod sm) {
        SootMethod _result;
        if (sc.declaresMethod(sm.getName(), sm.getParameterTypes(), sm.getReturnType())) {
            _result = sc.getMethod(sm.getName(), sm.getParameterTypes(), sm.getReturnType());
        } else if (Util.hasSuperclass(sc)) {
            _result = Util.findDeclaringMethod(sc.getSuperclass(), sm);
        } else {
            throw new IllegalStateException("Method " + sm + " not available in class " + sc + ".");
        }
        return _result;
    }

    @Functional
    public static SootMethod findMethodImplementation(@NonNull SootClass accessClass, @Immutable @NonNull String methodName, @NonNull @NonNullContainer List<Type> parameterTypes, @NonNull Type returnType) {
        SootMethod _result = null;
        if (accessClass.declaresMethod(methodName, parameterTypes, returnType)) {
            _result = accessClass.getMethod(methodName, parameterTypes, returnType);
        } else if (accessClass.hasSuperclass()) {
            SootClass _superClass = accessClass.getSuperclass();
            _result = Util.findMethodImplementation(_superClass, methodName, parameterTypes, returnType);
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error(String.valueOf(methodName) + "(" + parameterTypes + "):" + returnType + " is not accessible from " + accessClass);
        }
        return _result;
    }

    @Functional
    @NonNullContainer
    @NonNull
    public static Collection<SootMethod> findMethodInSuperClassesAndInterfaces(@NonNull SootMethod method) {
        HistoryAwareFIFOWorkBag _toProcess = new HistoryAwareFIFOWorkBag(new HashSet());
        Collection<Object> _result = new HashSet<SootMethod>();
        _toProcess.addWork(method.getDeclaringClass());
        List _parameterTypes = method.getParameterTypes();
        Type _retType = method.getReturnType();
        String _methodName = method.getName();
        while (_toProcess.hasWork()) {
            SootClass _sc = (SootClass)_toProcess.getWork();
            if (_sc.declaresMethod(_methodName, _parameterTypes, _retType)) {
                _result.add(_sc.getMethod(_methodName, _parameterTypes, _retType));
            }
            if (Util.hasSuperclass(_sc)) {
                SootClass _superClass = _sc.getSuperclass();
                _toProcess.addWorkNoDuplicates(_superClass);
            }
            for (SootClass _interface : _sc.getInterfaces()) {
                _toProcess.addWorkNoDuplicates(_interface);
            }
        }
        if (_result.isEmpty()) {
            _result = Collections.emptyList();
        }
        return _result;
    }

    @Immutable
    public static void fixupThreadStartBody(@NonNull Scene scm) {
        SootMethod _sm;
        SootClass _declClass = scm.getSootClass("java.lang.Thread");
        if (_declClass != null && (_sm = _declClass.getMethodByName("start")) != null) {
            JimpleBody _threadStartBody = null;
            if (_sm.isConcrete()) {
                _threadStartBody = (JimpleBody)_sm.retrieveActiveBody();
            }
            if (_threadStartBody == null) {
                _declClass.setApplicationClass();
                _declClass.setPhantom(false);
                _sm.setModifiers(_sm.getModifiers() & 0xFFFFFEFF);
                _sm.setPhantom(false);
                Jimple _jimple = Jimple.v();
                _threadStartBody = _jimple.newBody(_sm);
                PatchingChain _sl = _threadStartBody.getUnits();
                Local _thisRef = _jimple.newLocal("$this", (Type)RefType.v((String)_declClass.getName()));
                _threadStartBody.getLocals().add((Object)_thisRef);
                _sl.addFirst((Object)_jimple.newIdentityStmt((Value)_thisRef, (Value)_jimple.newThisRef(RefType.v((SootClass)_declClass))));
                VirtualInvokeExpr _ve = _jimple.newVirtualInvokeExpr(_thisRef, _declClass.getMethodByName("run"), Collections.EMPTY_LIST);
                _sl.addLast((Object)_jimple.newInvokeStmt((Value)_ve));
                _sl.addLast((Object)_jimple.newReturnVoidStmt());
                _sm.setActiveBody((Body)_threadStartBody);
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Fixed up java.lang.Thread.start() body");
                }
            }
        }
    }

    @Functional
    @NonNullContainer
    @NonNull
    public static Collection<SootClass> getAncestors(@NonNull SootClass sootClass) {
        HashSet<SootClass> _result = new HashSet<SootClass>();
        HashSet<SootClass> _temp = new HashSet<SootClass>();
        HistoryAwareLIFOWorkBag _wb = new HistoryAwareLIFOWorkBag(_result);
        _wb.addWork(sootClass);
        while (_wb.hasWork()) {
            SootClass _work = (SootClass)_wb.getWork();
            if (Util.hasSuperclass(_work)) {
                SootClass _superClass = _work.getSuperclass();
                _temp.add(_superClass);
            }
            _temp.addAll((Collection<SootClass>)_work.getInterfaces());
            for (SootClass _sc : _temp) {
                _wb.addWorkNoDuplicates(_sc);
            }
        }
        _result.remove(sootClass);
        return _result;
    }

    @Functional
    public static SootClass getDeclaringClass(@NonNull SootClass sc, @NonNull String method, @NonNullContainer @NonNull List<Type> parameterTypes, @NonNull Type returnType) {
        SootClass _contains = sc;
        while (!_contains.declaresMethod(method, parameterTypes, returnType)) {
            if (Util.hasSuperclass(_contains)) {
                _contains = _contains.getSuperclass();
                continue;
            }
            _contains = null;
            break;
        }
        return _contains;
    }

    @NonNull
    @Functional
    public static Value getDefaultValueFor(@NonNull Type type) {
        NullConstant _result = null;
        if (type instanceof RefLikeType) {
            _result = NullConstant.v();
        } else if (type instanceof IntType) {
            _result = IntConstant.v((int)0);
        } else if (type instanceof CharType) {
            _result = IntConstant.v((int)0);
        } else if (type instanceof ByteType) {
            _result = IntConstant.v((int)0);
        } else if (type instanceof BooleanType) {
            _result = IntConstant.v((int)0);
        } else if (type instanceof DoubleType) {
            _result = DoubleConstant.v((double)0.0);
        } else if (type instanceof FloatType) {
            _result = FloatConstant.v((float)0.0f);
        } else if (type instanceof LongType) {
            _result = LongConstant.v((long)0L);
        } else if (type instanceof ShortType) {
            _result = IntConstant.v((int)0);
        } else {
            LOGGER.error("Illegal type specified." + type);
            throw new IllegalArgumentException("Illegal type specified." + type);
        }
        return _result;
    }

    @Functional
    @NonNullContainer
    @NonNull
    public static List<Trap> getEnclosingTrap(@NonNull @NonNullContainer List<Trap> traps, @NonNull Stmt stmt, @NonNull @NonNullContainer List<Stmt> stmtList) {
        ArrayList<Trap> _result = new ArrayList<Trap>();
        int _stmtIndex = stmtList.indexOf(stmt);
        for (Trap _trap : traps) {
            if (stmtList.indexOf(_trap.getBeginUnit()) > _stmtIndex || _stmtIndex > stmtList.indexOf(_trap.getEndUnit())) continue;
            _result.add(_trap);
        }
        return _result;
    }

    @Functional
    @NonNull
    public static <T extends Host> Collection<T> getHostsWithTag(@NonNullContainer @NonNull Collection<T> hosts, @NonNull String tagName) {
        Collection<Host> _result = new ArrayList();
        for (Host _host : hosts) {
            if (!_host.hasTag(tagName)) continue;
            _result.add(_host);
        }
        if (_result.isEmpty()) {
            _result = Collections.emptyList();
        }
        return _result;
    }

    @Immutable
    public static Type getPrimitiveTypeFor(@NonNull @Immutable String typeName, @NonNull Scene scene) {
        IntType _result;
        if (typeName.equals("int")) {
            _result = IntType.v();
        } else if (typeName.equals("char")) {
            _result = CharType.v();
        } else if (typeName.equals("byte")) {
            _result = ByteType.v();
        } else if (typeName.equals("long")) {
            _result = LongType.v();
        } else if (typeName.equals("short")) {
            _result = ShortType.v();
        } else if (typeName.equals("float")) {
            _result = FloatType.v();
        } else if (typeName.equals("double")) {
            _result = DoubleType.v();
        } else if (typeName.equals("boolean")) {
            _result = BooleanType.v();
        } else if (typeName.equals("void")) {
            _result = VoidType.v();
        } else {
            SootClass _sc = scene.getSootClass(typeName);
            if (_sc == null) {
                String _msg = String.valueOf(typeName) + " is not available in the System.";
                LOGGER.error(_msg);
                throw new MissingResourceException("Given type is not available in the System", typeName, null);
            }
            _result = _sc.getType();
        }
        return _result;
    }

    @NonNull
    @Functional
    public static Collection<SootMethod> getResolvedMethods(@NonNullContainer @NonNull Collection<SootClass> newClasses) {
        HashSet<SootMethod> _col = new HashSet<SootMethod>();
        HashSet<String> _temp = new HashSet<String>();
        Iterator<SootClass> _i = newClasses.iterator();
        int _iEnd = newClasses.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootClass _sc = _i.next();
            List _methods = _sc.getMethods();
            _col.addAll(_methods);
            _temp.clear();
            Iterator _l = _methods.iterator();
            int _lEnd = _methods.size();
            int _lIndex = 0;
            while (_lIndex < _lEnd) {
                SootMethod _sm = (SootMethod)_l.next();
                _temp.add(_sm.getSubSignature());
                ++_lIndex;
            }
            SootClass _super = _sc;
            while (Util.hasSuperclass(_super)) {
                _super = _super.getSuperclass();
                Iterator _j = _super.getMethods().iterator();
                int _jEnd = _super.getMethods().size();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    SootMethod _superMethod = (SootMethod)_j.next();
                    if (!_temp.contains(_superMethod.getSubSignature())) {
                        _temp.add(_superMethod.getSubSignature());
                        _col.add(_superMethod);
                    }
                    ++_jIndex;
                }
            }
            ++_iIndex;
        }
        Iterator _j = _col.iterator();
        int _jEnd = _col.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            SootMethod _sm = (SootMethod)_j.next();
            if (_sm.getName().equals("<init>") && !newClasses.contains(_sm.getDeclaringClass())) {
                _j.remove();
            }
            ++_jIndex;
        }
        return _col;
    }

    @NonNull
    @NonNullContainer
    @Functional
    public static String[] getSootOptions() {
        String[] _options = new String[]{"-p", "jb", "enabled:true,use-original-names:false", "-p", "jb.ls", "enabled:true", "-p", "jb.a", "enabled:true,only-stack-locals:true", "-p", "jb.ulp", "enabled:false"};
        return _options;
    }

    @Immutable
    @NonNull
    public static Type getTypeFor(@NonNull @Immutable String typeName, @NonNull Scene scene) {
        int _i = typeName.indexOf("[", 0);
        Object _result = _i == -1 ? Util.getPrimitiveTypeFor(typeName, scene) : ArrayType.v((Type)Util.getPrimitiveTypeFor(typeName.substring(0, _i), scene), (int)(typeName.length() - _i));
        return _result;
    }

    @Functional
    public static boolean hasSuperclass(@NonNull SootClass sc) {
        boolean _result = false;
        if (!sc.getName().equals("java.lang.Object")) {
            _result = sc.hasSuperclass();
        }
        return _result;
    }

    @Functional
    public static boolean implementsInterface(@NonNull SootClass child, @NonNull String ancestor) {
        boolean _result = false;
        SootClass _temp = child;
        while (!_result && (_temp.getInterfaceCount() > 0 || Util.hasSuperclass(_temp))) {
            if (_temp.implementsInterface(ancestor)) {
                _result = true;
                continue;
            }
            _temp = _temp.getSuperclass();
        }
        return _result;
    }

    @Functional
    public static boolean isDescendentOf(@NonNull SootClass child, @NonNull SootClass ancestor) {
        return Util.isDescendentOf(child, ancestor.getName());
    }

    @Functional
    public static boolean isDescendentOf(@NonNull SootClass child, @NonNull String ancestor) {
        boolean _retval = false;
        SootClass _temp = child;
        while (!_retval) {
            if (_temp.getName().equals(ancestor)) {
                _retval = true;
                continue;
            }
            if (!Util.hasSuperclass(_temp)) break;
            _temp = _temp.getSuperclass();
        }
        if (!_retval) {
            _retval = Util.implementsInterface(child, ancestor);
        }
        return _retval;
    }

    @Functional
    public static boolean isHierarchicallyRelated(@NonNull SootClass class1, @NonNull SootClass class2) {
        return class1.equals(class2) || Util.isDescendentOf(class1, class2.getName()) || Util.isDescendentOf(class2, class1.getName());
    }

    @Functional
    public static boolean isNotifyInvocation(@NonNull InvokeStmt stmt, SootMethod method, ICallGraphInfo cgi) {
        InvokeExpr _expr = stmt.getInvokeExpr();
        SootMethod _sm = _expr.getMethod();
        boolean _result = Util.isNotifyMethod(_sm);
        if (_result && method != null && cgi != null) {
            _result = Util.wasMethodInvocationHelper(_sm, stmt, method, cgi);
        }
        return _result;
    }

    @Functional
    public static boolean isNotifyMethod(@NonNull SootMethod method) {
        return method.getDeclaringClass().getName().equals("java.lang.Object") && (method.getName().equals("notify") || method.getName().equals("notifyAll"));
    }

    @Functional
    public static boolean isReferenceType(@NonNull Type t) {
        return t instanceof RefType || t instanceof ArrayType || t instanceof NullType;
    }

    @Immutable
    public static boolean isSameOrSubType(@NonNull @Immutable Type t1, @NonNull @Immutable Type t2, @NonNull IEnvironment env) {
        boolean _result = false;
        if (t1.equals(t2)) {
            _result = true;
        } else if (t1 instanceof RefType && t2 instanceof RefType) {
            SootClass _c1 = env.getClass(((RefType)t1).getClassName());
            SootClass _c2 = env.getClass(((RefType)t2).getClassName());
            _result = Util.isDescendentOf(_c1, _c2);
        }
        return _result;
    }

    @Functional
    public static boolean isStartMethod(@NonNull SootMethod method) {
        return method.getName().equals("start") && method.getDeclaringClass().getName().equals("java.lang.Thread") && method.getReturnType() instanceof VoidType && method.getParameterCount() == 0;
    }

    @Immutable
    public static boolean isWaitInvocation(@NonNull @Immutable InvokeStmt stmt, @Immutable SootMethod method, @Immutable ICallGraphInfo cgi) {
        InvokeExpr _expr = stmt.getInvokeExpr();
        SootMethod _sm = _expr.getMethod();
        boolean _result = Util.isWaitMethod(_sm);
        if (_result && method != null && cgi != null) {
            _result = Util.wasMethodInvocationHelper(_sm, stmt, method, cgi);
        }
        return _result;
    }

    @Functional
    public static boolean isWaitMethod(@Immutable @NonNull SootMethod method) {
        return method.getDeclaringClass().getName().equals("java.lang.Object") && method.getName().equals("wait");
    }

    public static void pruneEnclosingTraps(@NonNullContainer @NonNull List<Trap> enclosingTraps) {
        ArrayList<Trap> _r = new ArrayList<Trap>();
        int _size = enclosingTraps.size();
        int _i = 0;
        while (_i < _size) {
            Trap _t1 = enclosingTraps.get(_i);
            SootClass _c1 = _t1.getException();
            int _j = _i + 1;
            while (_j < _size) {
                Trap _t2 = enclosingTraps.get(_j);
                SootClass _c2 = _t2.getException();
                if (Util.isDescendentOf(_c2, _c1)) {
                    _r.add(_t2);
                }
                ++_j;
            }
            enclosingTraps.removeAll(_r);
            _size -= _r.size();
            _r.clear();
            ++_i;
        }
    }

    @Immutable
    public static void removeMethodsWithSameSignature(@NonNullContainer @NonNull Collection<SootMethod> methods, @Immutable @NonNullContainer @NonNull Collection<SootMethod> methodsToRemove) {
        HashSet<SootMethod> _removeSet = new HashSet<SootMethod>();
        _removeSet.addAll(methods);
        Util.retainMethodsWithSameSignature(_removeSet, methodsToRemove);
        methods.removeAll(_removeSet);
    }

    @Immutable
    public static void retainMethodsWithSameSignature(@NonNullContainer @NonNull Collection<SootMethod> methods, @NonNullContainer @NonNull @Immutable Collection<SootMethod> methodsToRetain) {
        HashSet<SootMethod> _retainSet = new HashSet<SootMethod>();
        for (SootMethod _abstractMethod : methods) {
            for (SootMethod _method : methodsToRetain) {
                if (!_abstractMethod.getSubSignature().equals(_method.getSubSignature())) continue;
                _retainSet.add(_abstractMethod);
            }
        }
        methods.retainAll(_retainSet);
    }

    @Functional
    static boolean wasMethodInvocationHelper(@NonNull SootMethod invokedMethod, @NonNull InvokeStmt stmt, @NonNull SootMethod method, @NonNull ICallGraphInfo cgi) {
        Context _context = new Context();
        _context.setRootMethod(method);
        _context.setStmt((Stmt)stmt);
        boolean _result = false;
        Collection<SootMethod> _callees = cgi.getCallees(stmt.getInvokeExpr(), _context);
        Iterator<SootMethod> _iter = _callees.iterator();
        int _iterEnd = _callees.size();
        int _iterIndex = 0;
        while (_iterIndex < _iterEnd && !_result) {
            SootMethod _callee = _iter.next();
            _result |= _callee.equals(invokedMethod);
            ++_iterIndex;
        }
        return _result;
    }
}

