/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.ExceptionFlowSensitiveStmtGraph;
import edu.ksu.cis.indus.common.soot.ExceptionFlowSensitiveStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.TrapStmtGraphFactory;
import java.util.HashMap;
import java.util.Map;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.TrapUnitGraph;

public class UnitGraphFactoryTest
extends IndusTestCase {
    private Map factories;
    private Scene scene;

    public final void testGetUnitGraph() {
        SootClass _sc = this.scene.loadClassAndSupport("java.lang.Object");
        SootMethod _notify = _sc.getMethodByName("notify");
        SootMethod _equals = _sc.getMethodByName("equals");
        for (IStmtGraphFactory _factory : this.factories.keySet()) {
            Object _graph1 = _factory.getStmtGraph(_notify);
            UnitGraphFactoryTest.assertNotNull(_graph1);
            UnitGraphFactoryTest.assertTrue((boolean)((Class)this.factories.get(_factory)).isInstance(_graph1));
            Object _graph2 = _factory.getStmtGraph(_equals);
            UnitGraphFactoryTest.assertNotNull(_graph2);
            UnitGraphFactoryTest.assertTrue((boolean)((Class)this.factories.get(_factory)).isInstance(_graph2));
        }
    }

    public final void testReset() {
        SootClass _sc = this.scene.loadClassAndSupport("java.lang.Object");
        SootMethod _notify = _sc.getMethodByName("notify");
        for (IStmtGraphFactory _factory : this.factories.keySet()) {
            Object _graph1 = _factory.getStmtGraph(_notify);
            _factory.reset();
            Object _graph2 = _factory.getStmtGraph(_notify);
            UnitGraphFactoryTest.assertNotSame(_graph1, _graph2);
        }
    }

    protected void setUp() {
        this.scene = Scene.v();
        this.factories = new HashMap();
        this.factories.put(new CompleteStmtGraphFactory(), CompleteUnitGraph.class);
        this.factories.put(new TrapStmtGraphFactory(), TrapUnitGraph.class);
        this.factories.put(new ExceptionFlowSensitiveStmtGraphFactory(ExceptionFlowSensitiveStmtGraphFactory.SYNC_RELATED_EXCEPTIONS, true), ExceptionFlowSensitiveStmtGraph.class);
    }

    protected void tearDown() {
        this.factories.clear();
        this.scene = null;
        G.reset();
    }
}

