/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.scoping.SpecificationBasedScopeDefinition;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.RootMethodTrapper;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Printer;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.options.Options;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SootBasedDriver {
    private static final RootMethodTrapper DEFAULT_INSTANCE_OF_ROOT_METHOD_TRAPPER;
    private static final IStmtGraphFactory<?> DEFAULT_INSTANCE_OF_STMT_GRAPH_FACTORY;
    private static final Logger LOGGER;
    protected BasicBlockGraphMgr bbm;
    @NonNull
    protected IStmtGraphFactory<?> cfgProvider;
    @NonNullContainer
    @NonNull
    protected List<String> classNames;
    protected Logger infoLogger;
    @NonNullContainer
    @NonNull
    protected Collection<SootMethod> rootMethods = new HashSet<SootMethod>();
    @NonNull
    protected Scene scene;
    private String classpathToAdd;
    @NonNull
    private Environment env;
    @NonNull
    private RootMethodTrapper rootMethodTrapper;
    @NonNullContainer
    @NonNull
    private final Map<String, Long> times = new LinkedHashMap<String, Long>();

    static {
        LOGGER = LoggerFactory.getLogger(SootBasedDriver.class);
        String _rmtClassName = Constants.getRootMethodTrapperClassName();
        try {
            Object _o = SootBasedDriver.class.getClassLoader().loadClass(_rmtClassName).newInstance();
            if (!(_o instanceof RootMethodTrapper)) {
                String _msg = String.valueOf(_rmtClassName) + " is not a subclass of SootBasedDriver.RootMethodTrapper.";
                throw new IllegalArgumentException(_msg);
            }
            DEFAULT_INSTANCE_OF_ROOT_METHOD_TRAPPER = (RootMethodTrapper)_o;
        }
        catch (ClassNotFoundException _e) {
            LOGGER.error("class " + _rmtClassName + " could not be loaded/resolved. Bailing.", (Throwable)_e);
            throw new RuntimeException(_e);
        }
        catch (InstantiationException _e) {
            LOGGER.error("An instance of class " + _rmtClassName + " could not be created. Bailing.", (Throwable)_e);
            throw new RuntimeException(_e);
        }
        catch (IllegalAccessException _e) {
            LOGGER.error("No-arg constructor of " + _rmtClassName + " cannot be accessed.  Bailing.", (Throwable)_e);
            throw new RuntimeException(_e);
        }
        String _nameOfStmtGraphFactoryClass = Constants.getStmtGraphFactoryClassName();
        try {
            Object _o = SootBasedDriver.class.getClassLoader().loadClass(_nameOfStmtGraphFactoryClass).newInstance();
            if (!(_o instanceof IStmtGraphFactory)) {
                throw new IllegalArgumentException(String.valueOf(_nameOfStmtGraphFactoryClass) + " is not a subclass of IStmtGraphFactory.");
            }
            DEFAULT_INSTANCE_OF_STMT_GRAPH_FACTORY = (IStmtGraphFactory)_o;
        }
        catch (ClassNotFoundException _e) {
            LOGGER.error("class " + _nameOfStmtGraphFactoryClass + " could not be loaded/resolved. Bailing.", (Throwable)_e);
            throw new RuntimeException(_e);
        }
        catch (InstantiationException _e) {
            LOGGER.error("An instance of class " + _nameOfStmtGraphFactoryClass + " could not be created. Bailing.", (Throwable)_e);
            throw new RuntimeException(_e);
        }
        catch (IllegalAccessException _e) {
            LOGGER.error("No-arg constructor of " + _nameOfStmtGraphFactoryClass + " cannot be accessed.  Bailing.", (Throwable)_e);
            throw new RuntimeException(_e);
        }
    }

    public SootBasedDriver() {
        this.cfgProvider = SootBasedDriver.getDefaultStmtGraphFactory();
        this.bbm = new BasicBlockGraphMgr();
        this.bbm.setStmtGraphFactory(this.cfgProvider);
    }

    @NonNull
    public static IStmtGraphFactory<?> getDefaultStmtGraphFactory() {
        return DEFAULT_INSTANCE_OF_STMT_GRAPH_FACTORY;
    }

    public final void addTimeLog(@NonNull @Immutable String name, long milliseconds) {
        this.times.put("[" + this.times.size() + "]" + name, new Long(milliseconds));
    }

    public final void addToSootClassPath(@NonNull @Immutable String classpath) {
        this.classpathToAdd = classpath;
    }

    @Functional
    @NonNull
    public final BasicBlockGraphMgr getBbm() {
        return this.bbm;
    }

    @Functional
    @NonNull
    public final IEnvironment getEnvironment() {
        return this.env;
    }

    @Functional
    @NonNullContainer
    @NonNull
    public final Collection<SootMethod> getRootMethods() {
        return Collections.unmodifiableCollection(this.rootMethods);
    }

    @Functional
    @NonNull
    public IStmtGraphFactory<?> getStmtGraphFactory() {
        return this.cfgProvider;
    }

    public final void initialize() {
        this.initialize(Util.getSootOptions());
    }

    public final void initialize(@NonNull String[] options) {
        if (this.classNames == null) {
            throw new RuntimeException("Please call setClassNames() before using this object.");
        }
        this.writeInfo("Loading classes....");
        this.scene = this.loadupClassesAndCollectMains(options);
        this.env = new Environment(this.scene);
    }

    @Functional
    public final void printTimingStats() {
        this.writeInfo("Timing statistics:");
        for (String _e : this.times.keySet()) {
            this.writeInfo(_e + " => " + this.times.get(_e) + "ms");
        }
    }

    public void reset() {
        this.rootMethods.clear();
        this.scene = null;
        this.times.clear();
    }

    public final void setClassNames(@NonNullContainer @NonNull Collection<String> s) {
        this.classNames = new ArrayList<String>(s);
    }

    public final void setInfoLogger(@NonNull Logger myLogger) {
        this.infoLogger = myLogger;
    }

    public final void setRootMethodTrapper(@NonNull RootMethodTrapper trapper) {
        this.rootMethodTrapper = trapper;
    }

    public void writeInfo(Object info) {
        if (this.infoLogger != null && this.infoLogger.isInfoEnabled()) {
            this.infoLogger.info(String.valueOf(info));
        }
    }

    protected void dumpJimpleAndClassFiles(@Immutable @NonNull String outputDirectory, boolean jimpleFile, boolean classFile) {
        if (!jimpleFile && !classFile) {
            return;
        }
        Printer _printer = Printer.v();
        for (SootClass _sc : this.scene.getClasses()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Dumping jimple for " + _sc);
            }
            for (SootMethod _sm : _sc.getMethods()) {
                if (!_sm.isConcrete()) continue;
                try {
                    _sm.retrieveActiveBody();
                }
                catch (RuntimeException _e) {
                    LOGGER.error("Failed to retrieve body for method " + _sm, (Throwable)_e);
                }
            }
            PrintWriter _writer = null;
            try {
                try {
                    if (jimpleFile) {
                        File _file = new File(String.valueOf(outputDirectory) + File.separator + _sc.getName() + ".jimple");
                        _writer = new PrintWriter(new FileWriter(_file));
                        _printer.printTo(_sc, _writer);
                    }
                    if (!classFile) continue;
                    _printer.write(_sc, outputDirectory);
                }
                catch (IOException _e) {
                    LOGGER.error("Error while writing " + _sc, (Throwable)_e);
                }
                catch (RuntimeException _e) {
                    LOGGER.error("Error while writing class file of " + _sc, (Throwable)_e);
                }
            }
            finally {
                if (_writer != null) {
                    _writer.flush();
                    _writer.close();
                }
            }
        }
    }

    @Functional
    protected final SpecificationBasedScopeDefinition setScopeSpecFile(@Immutable @NonNull String scopeSpecFileName) {
        SpecificationBasedScopeDefinition _result = null;
        if (scopeSpecFileName != null) {
            try {
                FileInputStream _in = new FileInputStream(scopeSpecFileName);
                String _contents = IOUtils.toString((InputStream)_in);
                IOUtils.closeQuietly((InputStream)_in);
                _result = SpecificationBasedScopeDefinition.deserialize(_contents);
            }
            catch (IOException _e) {
                String _msg = "Error retrieved specification from " + scopeSpecFileName;
                LOGGER.error(_msg, (Throwable)_e);
                IllegalArgumentException _i = new IllegalArgumentException(_msg);
                _i.initCause(_e);
                throw _i;
            }
            catch (JiBXException _e) {
                LOGGER.error("JiBX failed during deserialization.", (Throwable)_e);
                IllegalStateException _i = new IllegalStateException("JiBX failed during deserialization.");
                _i.initCause(_e);
                throw _i;
            }
        }
        this.cfgProvider.setScope(_result, this.getEnvironment());
        return _result;
    }

    @NonNull
    Scene loadupClassesAndCollectMains(@NonNull String[] options) {
        Scene _result = Scene.v();
        String _temp = _result.getSootClassPath();
        Options.v().parse(options);
        _temp = _temp != null ? String.valueOf(_temp) + File.pathSeparator + this.classpathToAdd + File.pathSeparator + System.getProperty("java.class.path") : this.classpathToAdd;
        _result.setSootClassPath(_temp);
        Iterator<String> _i = this.classNames.iterator();
        while (_i.hasNext()) {
            SootClass _sc = _result.loadClassAndSupport(_i.next());
            _sc.setApplicationClass();
        }
        HashSet _mc = new HashSet();
        _mc.addAll(_result.getClasses());
        RootMethodTrapper _rmt = this.rootMethodTrapper;
        if (_rmt == null) {
            _rmt = DEFAULT_INSTANCE_OF_ROOT_METHOD_TRAPPER;
        }
        _rmt.setClassNames(Collections.unmodifiableCollection(this.classNames));
        for (SootClass _sc : _mc) {
            if (!_rmt.considerClassForEntryPoint(_sc)) continue;
            List _methods = _sc.getMethods();
            for (SootMethod _sm : _methods) {
                if (!_rmt.isThisARootMethod(_sm)) continue;
                this.rootMethods.add(_sm);
            }
        }
        Util.fixupThreadStartBody(_result);
        if (Constants.shouldLoadMethodBodiesDuringInitialization()) {
            this.loadupMethodBodies();
        }
        return _result;
    }

    private void loadupMethodBodies() {
        Chain _classes = Scene.v().getClasses();
        Iterator _i = _classes.iterator();
        int _iEnd = _classes.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootClass _sc = (SootClass)_i.next();
            List _methods = _sc.getMethods();
            Iterator _j = _methods.iterator();
            int _jEnd = _methods.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                SootMethod _sm = (SootMethod)_j.next();
                if (_sm.isConcrete()) {
                    _sm.retrieveActiveBody();
                }
                ++_jIndex;
            }
            ++_iIndex;
        }
    }
}

