/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootMethodTrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootMethodTrapper.class);
    @NonNullContainer
    @NonNull
    private final Collection<Pattern> rootClassNamePatterns = new HashSet<Pattern>();
    @NonNullContainer
    @NonNull
    private final Collection<Pattern> rootMethodSignaturePatterns = new HashSet<Pattern>();
    @NonNullContainer
    @NonNull
    private final Collection<String> theClassNames = new HashSet<String>();

    @Empty
    public RootMethodTrapper() {
        LOGGER.info("RootMethodTrapper: " + this.getClass().getName());
    }

    @Functional
    @NonNullContainer
    @NonNull
    public Collection<String> getClassNamePatterns() {
        ArrayList<String> _result = new ArrayList<String>();
        for (Pattern _pattern : this.rootClassNamePatterns) {
            _result.add(_pattern.pattern());
        }
        return _result;
    }

    @Functional
    @NonNullContainer
    @NonNull
    public Collection<String> getClassNames() {
        return new ArrayList<String>(this.theClassNames);
    }

    @Functional
    @NonNullContainer
    @NonNull
    public Collection<String> getMethodSignaturePatterns() {
        ArrayList<String> _result = new ArrayList<String>();
        for (Pattern _pattern : this.rootMethodSignaturePatterns) {
            _result.add(_pattern.pattern());
        }
        return _result;
    }

    public void setClassNamePatterns(@NonNullContainer @NonNull Collection<String> namePatterns) {
        this.rootClassNamePatterns.clear();
        for (String _patternString : namePatterns) {
            try {
                Pattern _pattern = Pattern.compile(_patternString);
                this.rootClassNamePatterns.add(_pattern);
            }
            catch (PatternSyntaxException _e) {
                LOGGER.error(String.valueOf(_patternString) + " was an invalid regular expression.  Ignored.", (Throwable)_e);
            }
        }
    }

    public void setClassNames(@NonNullContainer @NonNull @Immutable Collection<String> names) {
        this.theClassNames.clear();
        this.theClassNames.addAll(names);
    }

    public void setMethodSignaturePatterns(@NonNullContainer @NonNull @Immutable Collection<String> namePatterns) {
        this.rootMethodSignaturePatterns.clear();
        for (String _patternString : namePatterns) {
            try {
                Pattern _pattern = Pattern.compile(_patternString);
                this.rootMethodSignaturePatterns.add(_pattern);
            }
            catch (PatternSyntaxException _e) {
                LOGGER.error(String.valueOf(_patternString) + " was an invalid regular expression.  Ignored.", (Throwable)_e);
            }
        }
    }

    @Functional
    protected boolean considerClassForEntryPoint(@Immutable @NonNull SootClass sc) {
        boolean _result = false;
        String _scName = sc.getName();
        Iterator<Pattern> _i = this.rootClassNamePatterns.iterator();
        while (_i.hasNext() && !_result) {
            Pattern _pattern = _i.next();
            _result = _pattern.matcher(_scName).matches();
        }
        Iterator<String> _j = this.theClassNames.iterator();
        while (_j.hasNext() && !_result) {
            String _name = _j.next();
            _result = _name.equals(_scName);
        }
        return _result;
    }

    @Functional
    protected boolean isThisARootMethod(@NonNull @Immutable SootMethod sm) {
        boolean _result = false;
        Iterator<Pattern> _i = this.rootMethodSignaturePatterns.iterator();
        while (_i.hasNext() && !_result) {
            Pattern _pattern = _i.next();
            String _signature = sm.getSignature();
            _result = _pattern.matcher(_signature).matches();
        }
        return _result;
    }

    public static final class MainMethodTrapper
    extends RootMethodTrapper {
        @Empty
        public MainMethodTrapper() {
        }

        protected boolean isThisARootMethod(@Immutable @NonNull SootMethod sm) {
            boolean _result = sm.getName().equals("main") && sm.isPublic() && sm.isStatic() && sm.getParameterCount() == 1 && sm.getReturnType().equals(VoidType.v()) && sm.getParameterType(0).equals(ArrayType.v((Type)RefType.v((String)"java.lang.String"), (int)1));
            return _result;
        }
    }

    public static final class AllNonPrivateMethodsInAppClassesTrapper
    extends RootMethodTrapper {
        @Empty
        public AllNonPrivateMethodsInAppClassesTrapper() {
        }

        protected boolean isThisARootMethod(@Immutable @NonNull SootMethod sm) {
            return !sm.isPrivate();
        }
    }
}

