/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.ProcessingController;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.decorator.TObjectIntHashMapDecorator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import soot.Body;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.InvokeExprBox;
import soot.toolkits.graph.CompleteUnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetricsProcessor
extends AbstractProcessor {
    private final TObjectIntHashMap applicationStatistics = new TObjectIntHashMap();
    private final TObjectIntHashMap libraryStatistics = new TObjectIntHashMap();
    private TObjectIntHashMap statistics;

    @Override
    public void callback(@Immutable @NonNull SootClass clazz) {
        this.statistics = clazz.isApplicationClass() ? this.applicationStatistics : this.libraryStatistics;
        if (!this.statistics.increment((Object)MetricKeys.NUM_OF_CLASSES)) {
            this.statistics.put((Object)MetricKeys.NUM_OF_CLASSES, 1);
        }
    }

    @Override
    public void callback(@Immutable @NonNull SootField field) {
        if (!this.statistics.increment((Object)MetricKeys.NUM_OF_FIELDS)) {
            this.statistics.put((Object)MetricKeys.NUM_OF_FIELDS, 1);
        }
        if (field.isFinal() && !this.statistics.increment((Object)MetricKeys.NUM_OF_FINAL_FIELDS)) {
            this.statistics.put((Object)MetricKeys.NUM_OF_FINAL_FIELDS, 1);
        }
    }

    @Override
    public void callback(@Immutable @NonNull SootMethod method) {
        if (!this.statistics.increment((Object)MetricKeys.NUM_OF_METHODS)) {
            this.statistics.put((Object)MetricKeys.NUM_OF_METHODS, 1);
        }
        if (method.hasActiveBody()) {
            int _localCount;
            Body _body = method.retrieveActiveBody();
            int _trapCount = _body.getTraps().size();
            if (!this.statistics.adjustValue((Object)MetricKeys.NUM_OF_CATCH_BLOCKS, _trapCount)) {
                this.statistics.put((Object)MetricKeys.NUM_OF_CATCH_BLOCKS, _trapCount);
            }
            if (!this.statistics.adjustValue((Object)MetricKeys.NUM_OF_LOCALS, _localCount = _body.getLocalCount())) {
                this.statistics.put((Object)MetricKeys.NUM_OF_LOCALS, _localCount);
            }
            this.calculateReturnPointStats(_body);
        }
    }

    @Override
    public void callback(@Immutable @NonNull Stmt stmt, Context context) {
        if (!this.statistics.increment((Object)stmt.getClass().getName())) {
            this.statistics.put((Object)stmt.getClass().getName(), 1);
        }
    }

    @Override
    public void callback(@Immutable @NonNull ValueBox vBox, Context context) {
        if (!this.statistics.increment((Object)vBox.getValue().getClass().getName())) {
            this.statistics.put((Object)vBox.getValue().getClass().getName(), 1);
        }
        if (vBox instanceof InvokeExprBox) {
            int _constArgs = 0;
            InvokeExpr _expr = (InvokeExpr)vBox.getValue();
            Iterator _i = _expr.getArgs().iterator();
            int _iEnd = _expr.getArgs().size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                Object _arg = _i.next();
                if (_arg instanceof Constant) {
                    ++_constArgs;
                }
                ++_iIndex;
            }
            if (!this.statistics.adjustValue((Object)MetricKeys.NUM_OF_CONSTANT_METHOD_ARGUMENTS, _constArgs)) {
                this.statistics.put((Object)MetricKeys.NUM_OF_CONSTANT_METHOD_ARGUMENTS, _constArgs);
            }
        }
    }

    @NonNull
    @Functional
    public Map<MetricKeys, Map<Object, Integer>> getStatistics() {
        HashMap<MetricKeys, Map<Object, Integer>> _result = new HashMap<MetricKeys, Map<Object, Integer>>();
        TreeMap _map1 = new TreeMap(ToStringBasedComparator.getComparator());
        _map1.putAll(new TObjectIntHashMapDecorator(this.applicationStatistics));
        _result.put(MetricKeys.APPLICATION_STATISTICS, _map1);
        TreeMap _map2 = new TreeMap(ToStringBasedComparator.getComparator());
        _map2.putAll(new TObjectIntHashMapDecorator(this.libraryStatistics));
        _result.put(MetricKeys.LIBRARY_STATISTICS, _map2);
        return _result;
    }

    @NonNull
    @Functional
    @NonNullContainer
    public Map<MetricKeys, Map<Object, Integer>> getSummary() {
        HashMap<Object, Integer> _app = new HashMap<Object, Integer>();
        Object[] objectArray = this.applicationStatistics.keys();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object o = objectArray[n];
            if (o instanceof MetricKeys) {
                _app.put(o, this.applicationStatistics.get(o));
            }
            ++n;
        }
        HashMap<Object, Integer> _lib = new HashMap<Object, Integer>();
        Object[] objectArray2 = this.libraryStatistics.keys();
        n2 = 0;
        int n3 = objectArray2.length;
        while (n2 < n3) {
            Object o = objectArray2[n2];
            if (o instanceof MetricKeys) {
                _lib.put(o, this.libraryStatistics.get(o));
            }
            ++n2;
        }
        HashMap<MetricKeys, Map<Object, Integer>> _result = new HashMap<MetricKeys, Map<Object, Integer>>();
        _result.put(MetricKeys.APPLICATION_STATISTICS, _app);
        _result.put(MetricKeys.LIBRARY_STATISTICS, _app);
        return _result;
    }

    @Override
    public void hookup(ProcessingController ppc) {
        ppc.register(this);
        ppc.registerForAllStmts(this);
        ppc.registerForAllValues(this);
    }

    @Override
    public void processingBegins() {
        this.applicationStatistics.clear();
        this.libraryStatistics.clear();
    }

    @Override
    public void unhook(ProcessingController ppc) {
        ppc.unregister(this);
        ppc.unregisterForAllStmts(this);
        ppc.unregisterForAllValues(this);
    }

    void calculateReturnPointStats(@NonNull @Immutable Body body) {
        int _exitPoints;
        int _returnPoints = 0;
        int _throwPoints = 0;
        CompleteUnitGraph _completeUnitGraph = new CompleteUnitGraph(body);
        List _tails = _completeUnitGraph.getTails();
        Iterator _i = _tails.iterator();
        int _iEnd = _tails.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Stmt _stmt = (Stmt)_i.next();
            if (_stmt instanceof ReturnStmt || _stmt instanceof ReturnVoidStmt) {
                ++_returnPoints;
            } else if (_stmt instanceof ThrowStmt) {
                ++_throwPoints;
            }
            ++_iIndex;
        }
        if (!this.statistics.adjustValue((Object)MetricKeys.NUM_OF_NORMAL_EXIT_POINTS_IN_METHODS, _returnPoints)) {
            this.statistics.put((Object)MetricKeys.NUM_OF_NORMAL_EXIT_POINTS_IN_METHODS, _returnPoints);
        }
        if (!this.statistics.adjustValue((Object)MetricKeys.NUM_OF_EXCEPTIONAL_EXIT_POINTS_IN_METHODS, _throwPoints)) {
            this.statistics.put((Object)MetricKeys.NUM_OF_EXCEPTIONAL_EXIT_POINTS_IN_METHODS, _throwPoints);
        }
        if ((_exitPoints = _returnPoints + _throwPoints) > 1) {
            if (!this.statistics.increment((Object)MetricKeys.NUM_OF_METHODS_WITH_MULTIPLE_EXIT_POINTS)) {
                this.statistics.put((Object)MetricKeys.NUM_OF_METHODS_WITH_MULTIPLE_EXIT_POINTS, 1);
            }
        } else if (_exitPoints == 0 && !this.statistics.increment((Object)MetricKeys.NUM_OF_METHODS_WITH_ZERO_EXIT_POINTS)) {
            this.statistics.put((Object)MetricKeys.NUM_OF_METHODS_WITH_ZERO_EXIT_POINTS, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetricKeys {
        APPLICATION_STATISTICS,
        LIBRARY_STATISTICS,
        NUM_OF_CATCH_BLOCKS,
        NUM_OF_CLASSES,
        NUM_OF_CONSTANT_METHOD_ARGUMENTS,
        NUM_OF_EXCEPTIONAL_EXIT_POINTS_IN_METHODS,
        NUM_OF_FIELDS,
        NUM_OF_FINAL_FIELDS,
        NUM_OF_LOCALS,
        NUM_OF_METHODS,
        NUM_OF_METHODS_WITH_MULTIPLE_EXIT_POINTS,
        NUM_OF_METHODS_WITH_ZERO_EXIT_POINTS,
        NUM_OF_NORMAL_EXIT_POINTS_IN_METHODS;

    }
}

