/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.soot.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.PatchingChain;
import soot.SootClass;
import soot.Trap;
import soot.TrapManager;
import soot.Unit;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.JimpleBody;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExceptionFlowSensitiveStmtGraph
extends UnitGraph {
    private static final List<String> NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING = new ArrayList<String>();
    @NonNull
    @NonNullContainer
    private List<Stmt> nodes;
    @NonNull
    @NonNullContainer
    private Collection<Stmt> predsToBeProcessedCache = new HashSet<Stmt>();
    @NonNull
    @NonNullContainer
    private Collection<Stmt> succsToBeProcessedCache = new HashSet<Stmt>();

    static {
        NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING.add("java.lang.RuntimeException");
        NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING.add("java.lang.Exception");
        NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING.add("java.lang.Throwable");
        NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING.add("java.lang.Error");
    }

    ExceptionFlowSensitiveStmtGraph(@NonNull JimpleBody unitBody, @NonNull Collection<String> namesOfExceptionsToIgnore, boolean exceptionEdges) {
        super((Body)unitBody, true, exceptionEdges);
        this.deleteEdgesResultingFromTheseExceptions(namesOfExceptionsToIgnore);
        this.pruneExceptionBasedControlFlow();
        for (Stmt _unit : this.succsToBeProcessedCache) {
            this.unitToSuccs.put(_unit, Collections.unmodifiableCollection((Collection)this.unitToSuccs.get(_unit)));
        }
        for (Stmt _unit : this.predsToBeProcessedCache) {
            this.unitToPreds.put(_unit, Collections.unmodifiableCollection((Collection)this.unitToPreds.get(_unit)));
        }
        this.predsToBeProcessedCache = null;
        this.succsToBeProcessedCache = null;
        this.fixupMapsAndIterator();
    }

    @Functional
    @NonNull
    public Iterator<Stmt> iterator() {
        return this.nodes.iterator();
    }

    void deleteEdgesResultingFromTheseExceptions(@NonNullContainer @NonNull Collection<String> namesOfExceptionsToIgnore) {
        Chain _traps = this.body.getTraps();
        PatchingChain _units = this.body.getUnits();
        Iterator _j = _traps.iterator();
        while (_j.hasNext()) {
            Trap _trap = (Trap)_j.next();
            if (!namesOfExceptionsToIgnore.contains(_trap.getException().getName())) continue;
            Stmt _handler = (Stmt)_trap.getHandlerUnit();
            Stmt _endUnit = (Stmt)_units.getPredOf((Object)_trap.getEndUnit());
            ArrayList _preds = new ArrayList((Collection)this.unitToPreds.get(_handler));
            Iterator _i = _units.iterator((Object)_trap.getBeginUnit(), (Object)_endUnit);
            while (_i.hasNext()) {
                Stmt _unit = (Stmt)_i.next();
                ArrayList _succs = new ArrayList((Collection)this.unitToSuccs.get(_unit));
                _succs.remove(_handler);
                this.unitToSuccs.put(_unit, _succs);
                this.succsToBeProcessedCache.add(_unit);
                _preds.remove(_unit);
            }
            this.unitToPreds.put(_handler, _preds);
            this.predsToBeProcessedCache.add(_handler);
            _j.remove();
        }
    }

    private void fixupMapsAndIterator() {
        ArrayList _temp = new ArrayList();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_temp);
        PatchingChain _units = this.getBody().getUnits();
        _wb.addWork(_units.getFirst());
        while (_wb.hasWork()) {
            Stmt _unit = (Stmt)_wb.getWork();
            _wb.addAllWork(this.getSuccsOf(_unit));
        }
        this.nodes = new ArrayList<Stmt>((Collection<Stmt>)_units);
        this.nodes.retainAll(_temp);
        this.nodes = Collections.unmodifiableList(this.nodes);
        ArrayList _stmts = new ArrayList(_units);
        _stmts.removeAll(_temp);
        for (Object _stmt : _stmts) {
            this.unitToPreds.remove(_stmt);
            this.unitToSuccs.remove(_stmt);
        }
    }

    private void pruneExceptionBasedControlFlow() {
        for (Stmt _unit : TrapManager.getTrappedUnitsOf((Body)this.body)) {
            List _traps = TrapManager.getTrapsAt((Unit)_unit, (Body)this.body);
            for (Trap _trap : _traps) {
                SootClass _exception = _trap.getException();
                if (NAMES_OF_EXCEPTIONS_TO_IGNORE_WHILE_CFG_PRUNING.contains(_exception.getName())) continue;
                Stmt _handler = (Stmt)_trap.getHandlerUnit();
                boolean _hasArrayRef = _unit.containsArrayRef();
                boolean _hasFieldRef = _unit.containsFieldRef();
                boolean _hasInstanceFieldRef = _hasFieldRef && _unit.getFieldRef() instanceof InstanceFieldRef;
                boolean _hasInvokeExpr = _unit.containsInvokeExpr();
                InvokeExpr _invokeExpr = _hasInvokeExpr ? _unit.getInvokeExpr() : null;
                boolean _hasInstanceInvokeExpr = _hasInvokeExpr && _invokeExpr instanceof InstanceInvokeExpr;
                boolean _retainflag = (_hasArrayRef || _hasInstanceFieldRef || _hasInstanceInvokeExpr) && Util.isDescendentOf(_exception, "java.lang.NullPointerException");
                _retainflag |= _hasArrayRef && Util.isDescendentOf(_exception, "java.lang.ArrayIndexOutOfBoundsException");
                if (_hasInvokeExpr) {
                    for (SootClass _thrown : _invokeExpr.getMethod().getExceptions()) {
                        _retainflag |= Util.isDescendentOf(_thrown, _exception);
                    }
                }
                if (_retainflag) continue;
                ArrayList _preds = new ArrayList((Collection)this.unitToPreds.get(_handler));
                _preds.remove(_unit);
                this.unitToPreds.put(_handler, _preds);
                this.predsToBeProcessedCache.add(_handler);
                ArrayList _succs = new ArrayList((Collection)this.unitToSuccs.get(_unit));
                _succs.remove(_handler);
                this.unitToSuccs.put(_unit, _succs);
                this.succsToBeProcessedCache.add(_unit);
            }
        }
    }
}

