/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class Constants {
    public static final String CONSTANTS_CONFIGURATION_FILE_PROPERTY = "indus.constant.configuration.properties.file";
    public static final String LOAD_METHOD_BODIES_DURING_INITIALIZATION = "edu.ksu.cis.indus.common.soot.SootBasedDriver.LoadMethodBodiesDuringInit";
    public static final String NUM_OF_CLASSES_IN_APPLICATION_PROPERTY = "edu.ksu.cis.indus.NumOfClassesInApplication";
    public static final String NUM_OF_FIELDS_IN_APPLICATION_PROPERTY = "edu.ksu.cis.indus.NumOfFieldsInApplication";
    public static final String NUM_OF_METHODS_IN_APPLICATION_PROPERTY = "edu.ksu.cis.indus.NumOfMethodsInApplication";
    public static final String ROOT_METHOD_TRAPPER_CLASS_PROPERTY = "edu.ksu.cis.indus.common.soot.RootMethodTrapper.class";
    public static final String STMT_GRAPH_FACTORY_CLASS_PROPERTY = "edu.ksu.cis.indus.common.soot.SootBasedDriver.StmtGraphFactory.class";
    private static final Properties CONFIGURATIONS = new Properties();
    private static final int DEFAULT_NUM_OF_CLASSES_IN_APPLICATION = 1000;
    private static final int DEFAULT_NUM_OF_FIELDS_IN_APPLICATION = 3000;
    private static final int DEFAULT_NUM_OF_METHODS_IN_APPLICATION = 5000;

    static {
        String _propFileName = System.getProperty(CONSTANTS_CONFIGURATION_FILE_PROPERTY);
        if (_propFileName != null) {
            try {
                InputStream _stream = ClassLoader.getSystemResourceAsStream(_propFileName);
                CONFIGURATIONS.load(_stream);
            }
            catch (IOException _e) {
                System.err.println("Well, error loading property file.  Bailing.");
                throw new RuntimeException(_e);
            }
        }
    }

    @Empty
    private Constants() {
    }

    public static int getNumOfClassesInApplication() {
        int _result = Constants.retrieveIntValue(1000, NUM_OF_CLASSES_IN_APPLICATION_PROPERTY, CONFIGURATIONS);
        return _result;
    }

    public static int getNumOfFieldsInApplication() {
        int _result = Constants.retrieveIntValue(3000, NUM_OF_FIELDS_IN_APPLICATION_PROPERTY, CONFIGURATIONS);
        return _result;
    }

    public static int getNumOfMethodsInApplication() {
        int _result = Constants.retrieveIntValue(5000, NUM_OF_METHODS_IN_APPLICATION_PROPERTY, CONFIGURATIONS);
        return _result;
    }

    @NonNull
    public static String getRootMethodTrapperClassName() {
        String _result = CONFIGURATIONS.getProperty(ROOT_METHOD_TRAPPER_CLASS_PROPERTY);
        if (_result == null) {
            _result = "edu.ksu.cis.indus.common.soot.RootMethodTrapper$MainMethodTrapper";
        }
        return _result;
    }

    @NonNull
    public static String getStmtGraphFactoryClassName() {
        String _result = CONFIGURATIONS.getProperty(STMT_GRAPH_FACTORY_CLASS_PROPERTY);
        if (_result == null) {
            _result = "edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory";
        }
        return _result;
    }

    public static int retrieveIntValue(int defaultValue, String key, Properties props) throws NumberFormatException {
        String _temp = props.getProperty(key);
        int _result = _temp != null ? Integer.parseInt(_temp) : defaultValue;
        return _result;
    }

    public static boolean shouldLoadMethodBodiesDuringInitialization() {
        String _temp = CONFIGURATIONS.getProperty(LOAD_METHOD_BODIES_DURING_INITIALIZATION);
        boolean _result = _temp != null ? Boolean.parseBoolean(_temp) : false;
        return _result;
    }
}

