/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.ProcessingController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ParameterRef;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassEraser
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassEraser.class);
    @NonNullContainer
    @NonNull
    private final Collection<SootClass> classesToErase;
    @NonNullContainer
    private final IWorkBag<Pair<SootClass, SootClass>> wbCache = new LIFOWorkBag<Pair<SootClass, SootClass>>();

    ClassEraser(@NonNull @NonNullContainer @Immutable Collection<SootClass> classes) {
        this.classesToErase = new HashSet<SootClass>(classes);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ClassEraser(classes = " + classes + ") - Classes to be erased");
        }
    }

    @Override
    public void callback(@NonNull SootClass clazz) {
        SootClass _superClass;
        super.callback(clazz);
        this.wbCache.clear();
        if (clazz.hasSuperclass() && this.classesToErase.contains(_superClass = clazz.getSuperclass())) {
            this.wbCache.addWork(new Pair<SootClass, SootClass>(clazz, _superClass));
        }
        Iterator _i = clazz.getInterfaces().iterator();
        int _iEnd = clazz.getInterfaces().size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootClass _intr = (SootClass)_i.next();
            if (this.classesToErase.contains(_intr)) {
                this.wbCache.addWork(new Pair<SootClass, SootClass>(clazz, _intr));
            }
            ++_iIndex;
        }
        while (this.wbCache.hasWork()) {
            Pair<SootClass, SootClass> _p = this.wbCache.getWork();
            SootClass _clazz = _p.getFirst();
            SootClass _superClass2 = _p.getSecond();
            if (_superClass2.isInterface()) {
                Chain _interfaces = _clazz.getInterfaces();
                _interfaces.remove(_superClass2);
                Chain _superSuperInterfaces = _superClass2.getInterfaces();
                _interfaces.addAll(_superSuperInterfaces);
                Iterator _j = _superSuperInterfaces.iterator();
                int _jEnd = _superSuperInterfaces.size();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    SootClass _superSuperInterface = (SootClass)_j.next();
                    if (this.classesToErase.contains(_superSuperInterface)) {
                        this.wbCache.addWork(new Pair<SootClass, SootClass>(_clazz, _superSuperInterface));
                    }
                    ++_jIndex;
                }
                continue;
            }
            if (!_superClass2.hasSuperclass()) continue;
            SootClass _superSuperClass = _superClass2.getSuperclass();
            _clazz.setSuperclass(_superSuperClass);
            if (!this.classesToErase.contains(_superSuperClass)) continue;
            this.wbCache.addWork(new Pair<SootClass, SootClass>(_clazz, _superSuperClass));
        }
    }

    @Override
    public void callback(@NonNull SootField field) {
        super.callback(field);
        field.setType(this.getType(field.getType()));
    }

    @Override
    public void callback(@NonNull SootMethod method) {
        super.callback(method);
        ArrayList<Object> _c = new ArrayList<Object>();
        Iterator _i = method.getExceptions().iterator();
        int _iEnd = method.getExceptions().size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootClass _sc = (SootClass)_i.next();
            _i.remove();
            _c.add(this.getClass(_sc));
            ++_iIndex;
        }
        method.getExceptions().addAll(_c);
        _c.clear();
        Iterator _j = method.getParameterTypes().iterator();
        int _jEnd = method.getParameterTypes().size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            Type _type = (Type)_j.next();
            _j.remove();
            _c.add(this.getType(_type));
            ++_jIndex;
        }
        method.setParameterTypes(_c);
        method.setReturnType(this.getType(method.getReturnType()));
        if (method.hasActiveBody()) {
            HashSet _traps = new HashSet(method.getActiveBody().getTraps());
            Iterator _k = _traps.iterator();
            int _kEnd = _c.size();
            int _kIndex = 0;
            while (_kIndex < _kEnd) {
                Trap _t = (Trap)_k.next();
                _t.setException(this.getClass(_t.getException()));
                ++_kIndex;
            }
        }
    }

    @Override
    public void callback(@Immutable @NonNull ValueBox vBox, @Immutable @NonNull Context context) {
        super.callback(vBox, context);
        Value _v = vBox.getValue();
        if (_v instanceof Local) {
            Local _l = (Local)_v;
            _l.setType(this.getType(_l.getType()));
        } else if (_v instanceof ParameterRef) {
            ParameterRef _l = (ParameterRef)_v;
            vBox.setValue((Value)new ParameterRef(this.getType(_l.getType()), _l.getIndex()));
        }
    }

    @Override
    public void hookup(@NonNull @Immutable ProcessingController ppc) {
        ppc.registerForAllValues(this);
        ppc.register(this);
    }

    @Override
    public void unhook(@NonNull @Immutable ProcessingController ppc) {
        ppc.unregisterForAllValues(this);
        ppc.unregister(this);
    }

    SootClass getClass(@NonNull SootClass clazz) {
        SootClass _result = clazz;
        while (this.classesToErase.contains(_result)) {
            if (!_result.hasSuperclass()) continue;
            _result = _result.getSuperclass();
        }
        return _result;
    }

    @NonNull
    @Functional
    Type getType(@NonNull Type type) {
        Type _result = type;
        if (_result instanceof RefType) {
            SootClass _t = ((RefType)type).getSootClass();
            _t = this.getClass(_t);
            _result = _t.getType();
        } else if (type instanceof ArrayType) {
            ArrayType _aType = (ArrayType)type;
            Type _bType = _aType.baseType;
            if (_bType instanceof RefType) {
                SootClass _t = ((RefType)_bType).getSootClass();
                _t = this.getClass(_t);
                _result = ArrayType.v((Type)_t.getType(), (int)_aType.numDimensions);
            }
        }
        return _result;
    }
}

