/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.TestHelper;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.graph.AbstractDirectedGraphTest;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.ExceptionFlowSensitiveStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.TrapStmtGraphFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;

public class BasicBlockGraphTest
extends AbstractDirectedGraphTest {
    IStmtGraphFactory factory;
    Scene scene;
    private BasicBlockGraph bbGraph;
    private String className;
    private String methodName;

    static Test getTests() {
        final TestSuite _result = new TestSuite();
        _result.setName("BasicBlockGraphTest");
        IStmtGraphFactory[] _factories = new IStmtGraphFactory[]{new CompleteStmtGraphFactory(), new TrapStmtGraphFactory(), new ExceptionFlowSensitiveStmtGraphFactory()};
        final String[] _methodNames = new String[]{"notify", "equals", "insertProviderAt"};
        final String[] _classNames = new String[]{"java.lang.Object", "java.lang.Object", "java.security.Security"};
        int _j = 0;
        while (_j < _methodNames.length) {
            int _i = 0;
            while (_i < _factories.length) {
                IStmtGraphFactory _factory = _factories[_i];
                TestSuite _temp = new TestSuite(BasicBlockGraphTest.class);
                String _prefix = String.valueOf(_factory.getClass().getName()) + ":BasicBlockGraphTest";
                Enumeration _enum = _temp.tests();
                while (_enum.hasMoreElements()) {
                    BasicBlockGraphTest _test = (BasicBlockGraphTest)((Object)_enum.nextElement());
                    _test.setTestName(String.valueOf(_prefix) + ":" + _methodNames[_j] + ":" + _classNames[_j] + ":" + _test.getTestMethodName());
                    _test.factory = _factory;
                    _test.methodName = _methodNames[_j];
                    _test.className = _classNames[_j];
                }
                _result.addTest((Test)_temp);
                ++_i;
            }
            ++_j;
        }
        return new TestSetup((Test)_result){
            private Scene scene;

            public void setUp() {
                this.scene = Scene.v();
                int _i = 0;
                while (_i < _classNames.length) {
                    this.scene.loadClassAndSupport(_classNames[_i]).getMethodByName(_methodNames[_i]);
                    ++_i;
                }
                for (BasicBlockGraphTest _element : TestHelper.getTestCasesReachableFromSuite(_result, BasicBlockGraphTest.class)) {
                    _element.scene = this.scene;
                }
            }

            public void tearDown() {
                this.scene = null;
                G.reset();
            }
        };
    }

    public final void testBasicBlockGraphAgainstStmtGraph() {
        UnitGraph _unitGraph = this.bbGraph.getStmtGraph();
        ArrayList _unitsInGraph = new ArrayList();
        ArrayList<Stmt> _unitsInBB = new ArrayList<Stmt>();
        CollectionUtils.addAll(_unitsInGraph, _unitGraph.iterator());
        for (BasicBlockGraph.BasicBlock _bb : this.bbGraph.getNodes()) {
            _unitsInBB.addAll(_bb.getStmtsOf());
        }
        BasicBlockGraphTest.assertTrue((String)(String.valueOf(_unitGraph.getClass().getName()) + ":" + _unitGraph.getBody().getMethod() + " - " + SetUtils.difference(_unitsInBB, _unitsInGraph).toString()), (boolean)_unitsInGraph.containsAll(_unitsInBB));
        BasicBlockGraphTest.assertTrue((String)(String.valueOf(_unitGraph.getClass().getName()) + ":" + _unitGraph.getBody().getMethod() + " - " + SetUtils.difference(_unitsInGraph, _unitsInBB).toString()), (boolean)_unitsInBB.containsAll(_unitsInGraph));
    }

    public final void testBasicBlockGraphStructure() {
        UnitGraph _unitGraph = this.bbGraph.getStmtGraph();
        ArrayList<Stmt> _units = new ArrayList<Stmt>();
        for (BasicBlockGraph.BasicBlock _bb : this.bbGraph.getNodes()) {
            Stmt _trailer;
            List _succs;
            Stmt _leader = _bb.getLeaderStmt();
            List _preds = _unitGraph.getPredsOf((Object)_leader);
            if (!_preds.isEmpty()) {
                boolean _flag;
                boolean bl = _flag = _preds.size() > 1;
                if (!_flag) {
                    for (Stmt _pred : _preds) {
                        _flag |= _unitGraph.getSuccsOf((Object)_pred).size() > 1;
                    }
                }
                BasicBlockGraphTest.assertTrue((String)(String.valueOf(_leader.toString()) + _unitGraph.getBody().getMethod()), (boolean)_flag);
            }
            if (!(_succs = _unitGraph.getSuccsOf((Object)(_trailer = _bb.getTrailerStmt()))).isEmpty()) {
                boolean _flag;
                boolean bl = _flag = _succs.size() > 1;
                if (!_flag) {
                    for (Stmt _succ : _succs) {
                        _flag |= _unitGraph.getPredsOf((Object)_succ).size() > 1;
                    }
                }
                BasicBlockGraphTest.assertTrue((String)(String.valueOf(_trailer.toString()) + _unitGraph.getBody().getMethod()), (boolean)_flag);
            }
            _units.clear();
            _units.addAll(_bb.getStmtsOf());
            _units.remove(_leader);
            _units.remove(_trailer);
            for (Stmt _unit : _units) {
                BasicBlockGraphTest.assertTrue((_unitGraph.getPredsOf((Object)_unit).size() == 1 ? 1 : 0) != 0);
                BasicBlockGraphTest.assertTrue((_unitGraph.getSuccsOf((Object)_unit).size() == 1 ? 1 : 0) != 0);
            }
        }
    }

    protected void setUp() {
        BasicBlockGraphMgr _mgr = new BasicBlockGraphMgr();
        _mgr.setStmtGraphFactory(this.factory);
        SootClass _sc = this.scene.getSootClass(this.className);
        SootMethod _sm = _sc.getMethodByName(this.methodName);
        this.bbGraph = _mgr.getBasicBlockGraph(_sm);
        this.dg = this.bbGraph;
    }

    protected void tearDown() throws Exception {
        this.factory.reset();
        this.methodName = null;
        this.className = null;
        this.factory = null;
        this.bbGraph = null;
        this.dg = null;
        this.scene = null;
    }
}

