/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.collections.IteratorUtils;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.IExceptionRaisingInfo;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicBlockGraphMgr {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicBlockGraphMgr.class);
    private final IExceptionRaisingInfo eti;
    @NonNull
    @NonNullContainer
    private final Map<SootMethod, Reference<BasicBlockGraph>> method2graph;
    @NonNull
    @NonNullContainer
    private final Map<SootMethod, List<Stmt>> method2stmtlist = new HashMap<SootMethod, List<Stmt>>();
    private IStmtGraphFactory<?> stmtGraphProvider;

    @Empty
    public BasicBlockGraphMgr() {
        this(null);
    }

    public BasicBlockGraphMgr(@Immutable IExceptionRaisingInfo info) {
        this.eti = info;
        this.method2graph = new HashMap<SootMethod, Reference<BasicBlockGraph>>(Constants.getNumOfMethodsInApplication());
    }

    public BasicBlockGraph getBasicBlockGraph(@NonNull SootMethod sm) throws IllegalStateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getBasicBlockGraph(SootMethod sm = " + sm + ") - BEGIN");
        }
        if (this.stmtGraphProvider == null) {
            throw new IllegalStateException("You need to set the unit graph provider via setStmtGraphFactory() before calling this method.");
        }
        Reference<BasicBlockGraph> _ref = this.method2graph.get(sm);
        BasicBlockGraph _result = null;
        boolean _flag = false;
        if (_ref == null) {
            _flag = true;
        } else {
            _result = _ref.get();
            if (_result == null) {
                _flag = true;
            }
        }
        if (_flag) {
            Object _graph = this.stmtGraphProvider.getStmtGraph(sm);
            _result = new BasicBlockGraph((UnitGraph)_graph, sm, this.eti);
            this.method2graph.put(sm, new SoftReference<BasicBlockGraph>(_result));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getBasicBlockGraph() - END - return value = " + _result);
        }
        return _result;
    }

    @NonNull
    public UnitGraph getStmtGraph(@NonNull SootMethod method) {
        return this.stmtGraphProvider.getStmtGraph(method);
    }

    @NonNull
    @NonNullContainer
    public List<Stmt> getStmtList(@NonNull SootMethod method) {
        List<Object> _result;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getStmtList(method = " + method + ")");
        }
        if ((_result = this.method2stmtlist.get(method)) == null) {
            UnitGraph _stmtGraph = this.getStmtGraph(method);
            if (_stmtGraph != null) {
                List _toList = IteratorUtils.toList(_stmtGraph.iterator());
                _result = Collections.unmodifiableList(_toList);
            } else {
                _result = Collections.emptyList();
            }
            this.method2stmtlist.put(method, _result);
        }
        return _result;
    }

    public void reset() {
        this.method2graph.clear();
        this.method2stmtlist.clear();
    }

    public <T extends UnitGraph> void setStmtGraphFactory(@NonNull @Immutable IStmtGraphFactory<T> cfgProvider) {
        this.stmtGraphProvider = cfgProvider;
    }
}

