/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.graph.MutableDirectedGraph;
import edu.ksu.cis.indus.common.graph.MutableNode;
import edu.ksu.cis.indus.interfaces.IExceptionRaisingInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Trap;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicBlockGraph
extends MutableDirectedGraph<BasicBlock> {
    static final Logger LOGGER = LoggerFactory.getLogger(BasicBlockGraph.class);
    @NonNull
    @NonNullContainer
    final List<Stmt> stmtList;
    @NonNull
    @NonNullContainer
    private final Map<Stmt, BasicBlock> stmt2BlockMap;
    @NonNull
    private final UnitGraph stmtGraph;

    public BasicBlockGraph(@NonNull @Immutable UnitGraph theStmtGraph, @NonNull @Immutable SootMethod method, @Immutable IExceptionRaisingInfo analysis) {
        this.stmtGraph = theStmtGraph;
        ArrayList _units = new ArrayList(this.stmtGraph.getBody().getUnits());
        this.stmtList = Collections.unmodifiableList(_units);
        int _numOfStmt = this.stmtList.size();
        if (_numOfStmt == 0) {
            this.stmt2BlockMap = Collections.emptyMap();
            return;
        }
        ArrayList<Stmt> _stmts = new ArrayList<Stmt>();
        HistoryAwareLIFOWorkBag<Stmt> _wb = new HistoryAwareLIFOWorkBag<Stmt>(new HashSet());
        _wb.addWork(this.stmtList.get(0));
        this.stmt2BlockMap = new HashMap<Stmt, BasicBlock>(_numOfStmt);
        while (_wb.hasWork()) {
            _stmts.clear();
            Stmt _stmt = (Stmt)_wb.getWork();
            boolean _isExitBlock = this.getBasicBlockStmts(_stmt, _wb, _stmts, analysis, method);
            BasicBlock _bblock = new BasicBlock(_stmts, _isExitBlock);
            Iterator _i = _stmts.iterator();
            while (_i.hasNext()) {
                this.stmt2BlockMap.put((Stmt)_i.next(), _bblock);
            }
            this.addNode(_bblock);
        }
        this.setupGraph();
    }

    @NonNull
    @NonNullContainer
    public List<Stmt> getEnclosedStmts(@NonNull @NonNullContainer @Immutable Collection<BasicBlock> basicBlocks) {
        ArrayList<Stmt> _result = new ArrayList<Stmt>();
        Iterator<BasicBlock> _i = basicBlocks.iterator();
        int _iEnd = basicBlocks.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            BasicBlock _bb = _i.next();
            _result.addAll(_bb.getStmtsOf());
            ++_iIndex;
        }
        return _result;
    }

    @NonNull
    @NonNullContainer
    public List<BasicBlock> getEnclosingBasicBlocks(@NonNull @NonNullContainer @Immutable Collection<Stmt> stmts) {
        ArrayList<BasicBlock> _result = new ArrayList<BasicBlock>();
        Iterator<Stmt> _i = stmts.iterator();
        int _iEnd = stmts.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Stmt _stmt = _i.next();
            BasicBlock _enclosingBlock = this.getEnclosingBlock(_stmt);
            if (_enclosingBlock != null) {
                _result.add(_enclosingBlock);
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("getEnclosedBasicBlocks() - One of the given statement is not represented by anyblock in the graph" + _stmt);
            }
            ++_iIndex;
        }
        return _result;
    }

    @Functional
    public BasicBlock getEnclosingBlock(Stmt stmt) {
        return this.stmt2BlockMap.get(stmt);
    }

    @NonNull
    @NonNullContainer
    @Functional
    public Collection<BasicBlock> getHandlerBlocks() {
        HashSet<BasicBlock> _handlerBlocks;
        Chain _traps = this.stmtGraph.getBody().getTraps();
        if (!_traps.isEmpty()) {
            _handlerBlocks = new HashSet<BasicBlock>();
            Iterator _i = _traps.iterator();
            while (_i.hasNext()) {
                BasicBlock _block = this.getEnclosingBlock((Stmt)((Trap)_i.next()).getHandlerUnit());
                if (_block == null) continue;
                _handlerBlocks.add(_block);
            }
        } else {
            _handlerBlocks = (HashSet<BasicBlock>)Collections.emptySet();
        }
        return _handlerBlocks;
    }

    @Functional
    public BasicBlock getHead() {
        Collection _heads = this.getSources();
        BasicBlock _result = null;
        if (_heads.size() == 1) {
            _result = (BasicBlock)_heads.iterator().next();
        } else {
            Stmt _stmt = (Stmt)this.stmtGraph.getBody().getUnits().getFirst();
            for (Stmt _t : this.stmtGraph) {
                if (!_stmt.equals(_t)) continue;
                _result = this.getEnclosingBlock(_stmt);
                break;
            }
        }
        return _result;
    }

    @NonNull
    @Functional
    public UnitGraph getStmtGraph() {
        return this.stmtGraph;
    }

    @Override
    @Functional
    @NonNull
    public String toString() {
        return new ToStringBuilder((Object)this).append("blocks", this.getNodes()).toString();
    }

    boolean getBasicBlockStmts(@NonNull @NonNullContainer @Immutable Stmt leaderStmt, @NonNull IWorkBag<Stmt> wb, @NonNull @NonNullContainer List<Stmt> stmts, @Immutable IExceptionRaisingInfo analysis, @NonNull @Immutable SootMethod method) {
        boolean _throwsUncaughtException;
        int _size;
        block8: {
            stmts.add(leaderStmt);
            List _t = this.stmtGraph.getSuccsOf((Object)leaderStmt);
            _size = _t.size();
            boolean bl = _throwsUncaughtException = analysis != null && analysis.doesStmtThrowUncaughtException(leaderStmt, method);
            if (_size == 1 && !_throwsUncaughtException) {
                List _succs;
                Stmt _pred = leaderStmt;
                Stmt _stmt = (Stmt)_t.iterator().next();
                while (true) {
                    List _preds;
                    if ((_preds = this.stmtGraph.getPredsOf((Object)_stmt)).size() > 1) {
                        wb.addWorkNoDuplicates(_stmt);
                    } else {
                        _succs = this.stmtGraph.getSuccsOf((Object)_stmt);
                        _size = _succs.size();
                        boolean bl2 = _throwsUncaughtException = analysis != null && analysis.doesStmtThrowUncaughtException(_stmt, method);
                        if (_size != 1 || _throwsUncaughtException) break;
                        if (!stmts.contains(_stmt)) {
                            stmts.add(_stmt);
                            _pred = _stmt;
                            _stmt = (Stmt)this.stmtGraph.getSuccsOf((Object)_pred).get(0);
                            continue;
                        }
                    }
                    break block8;
                    break;
                }
                stmts.add(_stmt);
                if (_size > 1 || _throwsUncaughtException) {
                    wb.addAllWorkNoDuplicates(_succs);
                }
            } else if (_size > 1 || _throwsUncaughtException) {
                wb.addAllWorkNoDuplicates(_t);
            }
        }
        return _throwsUncaughtException || _size == 0;
    }

    private void setupGraph() {
        for (BasicBlock _block : this.getNodes()) {
            Stmt _stmt = _block.getTrailerStmt();
            for (Stmt _succ : this.stmtGraph.getSuccsOf((Object)_stmt)) {
                BasicBlock _succBlock = this.getEnclosingBlock(_succ);
                if (_succBlock == null) continue;
                this.addEdgeFromTo(_block, _succBlock);
            }
        }
        this.shapeChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class BasicBlock
    extends MutableNode<BasicBlock> {
        private final boolean isExitBlock;
        @NonNull
        private final Stmt leaderStmt;
        @NonNull
        @NonNullContainer
        private final List<Stmt> stmts;
        @NonNull
        private final Stmt trailerStmt;

        BasicBlock(List<Stmt> stmtsParam, boolean isAnExitBlock) {
            super(new HashSet(), new HashSet());
            this.stmts = new ArrayList<Stmt>(stmtsParam);
            this.leaderStmt = this.stmts.get(0);
            this.trailerStmt = this.stmts.get(this.stmts.size() - 1);
            this.isExitBlock = isAnExitBlock;
        }

        @NonNull
        public Stmt getLeaderStmt() {
            return this.leaderStmt;
        }

        @Functional
        @NonNull
        @NonNullContainer
        public List<Stmt> getStmtsFrom(Stmt start) {
            return this.getStmtsFromTo(start, this.trailerStmt);
        }

        @Functional
        @NonNullContainer
        @NonNull
        public List<Stmt> getStmtsFromTo(Stmt start, Stmt end) {
            List<Stmt> _result;
            int _startIndex = BasicBlockGraph.this.stmtList.indexOf(start);
            int _endIndex = BasicBlockGraph.this.stmtList.indexOf(end);
            int _leaderIndex = BasicBlockGraph.this.stmtList.indexOf(this.leaderStmt);
            int _trailerIndex = BasicBlockGraph.this.stmtList.indexOf(this.trailerStmt);
            if (_startIndex >= _leaderIndex && _endIndex <= _trailerIndex && _startIndex <= _endIndex) {
                _result = new ArrayList<Stmt>((Collection)BasicBlockGraph.this.stmtList.subList(_startIndex, _endIndex + 1));
                _result.retainAll(this.stmts);
            } else {
                int _localEndIndex;
                int _localStartIndex = this.stmts.indexOf(start);
                _result = _localStartIndex <= (_localEndIndex = this.stmts.indexOf(end)) && _localStartIndex != -1 ? new ArrayList<Stmt>((Collection)this.stmts.subList(_localStartIndex, _localEndIndex + 1)) : Collections.emptyList();
            }
            return _result;
        }

        @Functional
        @NonNullContainer
        @NonNull
        public List<Stmt> getStmtsOf() {
            return Collections.unmodifiableList(this.stmts);
        }

        @NonNull
        @NonNullContainer
        @Functional
        public Stmt getTrailerStmt() {
            return this.trailerStmt;
        }

        public boolean isAnExitBlock() {
            return this.isExitBlock;
        }

        @Functional
        @NonNull
        public String toString() {
            return new ToStringBuilder((Object)this).append("stmts", this.stmts).toString();
        }
    }
}

