/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.InternalUse;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import java.util.Collections;
import soot.Body;
import soot.PatchingChain;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.internal.AbstractStmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationInitInfoFactory {
    public static final String APPLICATION_STARTING_METHOD = "<applicationStartingMethod>";
    public static final String CLASS_INIT_THREAD_STARTING_METHOD = "<classInitThreadStartingMethod>";
    public static final String SYSTEM_INIT_CLASS = "$SystemInitClass$";

    @Empty
    private ApplicationInitInfoFactory() {
    }

    @NonNull
    public static Triple<InvokeStmt, SootMethod, SootClass> getApplicationStartingThread() {
        SootClass _sc;
        Scene _scene = Scene.v();
        if (!_scene.containsClass(SYSTEM_INIT_CLASS)) {
            ApplicationInitInfoFactory.setupSystemInitClass(_scene);
        }
        if (!(_sc = _scene.getSootClass(SYSTEM_INIT_CLASS)).declaresMethod(APPLICATION_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v())) {
            ApplicationInitInfoFactory.setupAppStartingMethod(_sc);
        }
        SootMethod _sm = _sc.getMethod(APPLICATION_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v());
        Object _first = _sm.getActiveBody().getUnits().getFirst();
        return new Triple<InvokeStmt, SootMethod, SootClass>((InvokeStmt)_sm.getActiveBody().getUnits().getSuccOf(_first), _sm, _sc);
    }

    @NonNull
    public static Pair<AssignStmt, SootMethod> getApplicationStartingThreadAllocationSite() {
        SootClass _sc;
        Scene _scene = Scene.v();
        if (!_scene.containsClass(SYSTEM_INIT_CLASS)) {
            ApplicationInitInfoFactory.setupSystemInitClass(_scene);
        }
        if (!(_sc = _scene.getSootClass(SYSTEM_INIT_CLASS)).declaresMethod(APPLICATION_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v())) {
            ApplicationInitInfoFactory.setupAppStartingMethod(_sc);
        }
        SootMethod _sm = _sc.getMethod(APPLICATION_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v());
        return new Pair<AssignStmt, SootMethod>((AssignStmt)_sm.getActiveBody().getUnits().getFirst(), _sm);
    }

    @NonNull
    public static Pair<InvokeStmt, SootMethod> getApplicationStartingThreadCreationSite() {
        SootClass _sc;
        Scene _scene = Scene.v();
        if (!_scene.containsClass(SYSTEM_INIT_CLASS)) {
            ApplicationInitInfoFactory.setupSystemInitClass(_scene);
        }
        if (!(_sc = _scene.getSootClass(SYSTEM_INIT_CLASS)).declaresMethod(APPLICATION_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v())) {
            ApplicationInitInfoFactory.setupAppStartingMethod(_sc);
        }
        SootMethod _sm = _sc.getMethod(APPLICATION_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v());
        Object _first = _sm.getActiveBody().getUnits().getFirst();
        return new Pair<InvokeStmt, SootMethod>((InvokeStmt)_sm.getActiveBody().getUnits().getSuccOf(_first), _sm);
    }

    @NonNull
    public static Triple<InvokeStmt, SootMethod, SootClass> getClassInitExecutingThread() {
        SootClass _sc;
        Scene _scene = Scene.v();
        if (!_scene.containsClass(SYSTEM_INIT_CLASS)) {
            ApplicationInitInfoFactory.setupSystemInitClass(_scene);
        }
        if (!(_sc = _scene.getSootClass(SYSTEM_INIT_CLASS)).declaresMethod(CLASS_INIT_THREAD_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v())) {
            _sc.addMethod(new SootMethod(CLASS_INIT_THREAD_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v()));
        }
        SootMethod _sm = _sc.getMethod(CLASS_INIT_THREAD_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v());
        Object _first = _sm.getActiveBody().getUnits().getFirst();
        return new Triple<InvokeStmt, SootMethod, SootClass>((InvokeStmt)_sm.getActiveBody().getUnits().getSuccOf(_first), _sm, _sc);
    }

    @NonNull
    public static Pair<AssignStmt, SootMethod> getClassInitExecutingThreadAllocationSite() {
        SootClass _sc;
        Scene _scene = Scene.v();
        if (!_scene.containsClass(SYSTEM_INIT_CLASS)) {
            ApplicationInitInfoFactory.setupSystemInitClass(_scene);
        }
        if (!(_sc = _scene.getSootClass(SYSTEM_INIT_CLASS)).declaresMethod(CLASS_INIT_THREAD_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v())) {
            ApplicationInitInfoFactory.setupClassInitializingThreadStartingMethod(_sc);
        }
        SootMethod _sm = _sc.getMethod(CLASS_INIT_THREAD_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v());
        Object _first = _sm.getActiveBody().getUnits().getFirst();
        return new Pair<AssignStmt, SootMethod>((AssignStmt)_first, _sm);
    }

    @NonNull
    public static Pair<InvokeStmt, SootMethod> getClassInitExecutingThreadCreationSite() {
        SootClass _sc;
        Scene _scene = Scene.v();
        if (!_scene.containsClass(SYSTEM_INIT_CLASS)) {
            ApplicationInitInfoFactory.setupSystemInitClass(_scene);
        }
        if (!(_sc = _scene.getSootClass(SYSTEM_INIT_CLASS)).declaresMethod(CLASS_INIT_THREAD_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v())) {
            ApplicationInitInfoFactory.setupClassInitializingThreadStartingMethod(_sc);
        }
        SootMethod _sm = _sc.getMethod(CLASS_INIT_THREAD_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v());
        Object _first = _sm.getActiveBody().getUnits().getFirst();
        return new Pair<InvokeStmt, SootMethod>((InvokeStmt)_sm.getActiveBody().getUnits().getSuccOf(_first), _sm);
    }

    @Immutable
    static void setupAppStartingMethod(@NonNull SootClass sc) {
        SootMethod _sm = new SootMethod(APPLICATION_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v());
        JimpleBody _body = Jimple.v().newBody();
        _body.setMethod(_sm);
        PatchingChain _units = _body.getUnits();
        _units.add(new ThreadCreatingStmt());
        _units.add(new ThreadStartingStmt());
        _units.add(Jimple.v().newReturnVoidStmt());
        _sm.setActiveBody((Body)_body);
        sc.addMethod(_sm);
    }

    private static void setupClassInitializingThreadStartingMethod(SootClass sc) {
        SootMethod _sm = new SootMethod(CLASS_INIT_THREAD_STARTING_METHOD, Collections.EMPTY_LIST, (Type)VoidType.v());
        JimpleBody _body = Jimple.v().newBody();
        _body.setMethod(_sm);
        PatchingChain _units = _body.getUnits();
        _units.add(new ThreadCreatingStmt());
        _units.add(new ThreadStartingStmt());
        _units.add(Jimple.v().newReturnVoidStmt());
        _sm.setActiveBody((Body)_body);
        sc.addMethod(_sm);
    }

    @Immutable
    static void setupSystemInitClass(@NonNull Scene scene) {
        SootClass _sc = new SootClass(SYSTEM_INIT_CLASS);
        _sc.setSuperclass(scene.getSootClass("java.lang.Object"));
        scene.addClass(_sc);
    }

    @InternalUse
    static class ThreadCreatingStmt
    extends AbstractStmt
    implements AssignStmt {
        private static final long serialVersionUID = 2814575491539829268L;

        ThreadCreatingStmt() {
        }

        @Functional
        public boolean branches() {
            return false;
        }

        @Functional
        public Object clone() {
            return null;
        }

        @Functional
        public boolean fallsThrough() {
            return false;
        }

        @Functional
        public Value getLeftOp() {
            return null;
        }

        @Functional
        public ValueBox getLeftOpBox() {
            return null;
        }

        @Functional
        public Value getRightOp() {
            return null;
        }

        @Functional
        public ValueBox getRightOpBox() {
            return null;
        }

        @Empty
        public void setLeftOp(Value variable) {
        }

        @Empty
        public void setRightOp(Value rvalue) {
        }

        @Empty
        public void toString(UnitPrinter up) {
        }
    }

    @InternalUse
    static class ThreadStartingStmt
    extends AbstractStmt
    implements InvokeStmt {
        private static final long serialVersionUID = -4968749658097774678L;

        ThreadStartingStmt() {
        }

        @Functional
        public boolean branches() {
            return false;
        }

        @Functional
        public Object clone() {
            return null;
        }

        @Functional
        public boolean fallsThrough() {
            return false;
        }

        @Empty
        public void setInvokeExpr(Value invokeExpr) {
        }

        @Empty
        public void toString(UnitPrinter up) {
        }
    }
}

