/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.soot;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.scoping.SpecificationBasedScopeDefinition;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.VoidType;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.toolkits.graph.UnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStmtGraphFactory<T extends UnitGraph>
implements IStmtGraphFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStmtGraphFactory.class);
    protected SpecificationBasedScopeDefinition scope;
    @NonNull
    private IEnvironment environment;
    private final Map<SootMethod, T> method2UnitGraph = new HashMap<SootMethod, T>(Constants.getNumOfMethodsInApplication());

    @Override
    @NonNull
    public final T getStmtGraph(@NonNull @Immutable SootMethod method) {
        Object _result;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getStmtGraph(method = " + method + ")");
        }
        if ((_result = (UnitGraph)this.method2UnitGraph.get(method)) == null) {
            _result = this.getBodyForMethod(method);
            if (_result == null) {
                Jimple _jimple = Jimple.v();
                JimpleBody _body = _jimple.newBody();
                PatchingChain _units = _body.getUnits();
                _body.setMethod(method);
                if (!method.isStatic()) {
                    RefType _thisType = method.getDeclaringClass().getType();
                    Local _newLocal = _jimple.newLocal("r0", (Type)_thisType);
                    _body.getLocals().add((Object)_newLocal);
                    _units.add(_jimple.newIdentityStmt((Value)_newLocal, (Value)_jimple.newThisRef(_thisType)));
                }
                if (method.getParameterCount() > 0) {
                    int _j = 0;
                    for (Type _type : method.getParameterTypes()) {
                        Local _newLocal = _jimple.newLocal("p" + _j, _type);
                        _body.getLocals().add((Object)_newLocal);
                        _units.add(_jimple.newIdentityStmt((Value)_newLocal, (Value)_jimple.newParameterRef(_type, _j++)));
                    }
                }
                if (method.getReturnType() instanceof VoidType) {
                    _units.add(_jimple.newReturnVoidStmt());
                } else {
                    _units.add(_jimple.newReturnStmt(Util.getDefaultValueFor(method.getReturnType())));
                }
                _result = this.getStmtGraphForBody(_body);
            }
            this.method2UnitGraph.put(method, _result);
        }
        return (T)_result;
    }

    @Override
    public final void reset() {
        this.method2UnitGraph.clear();
    }

    @Override
    public void setScope(SpecificationBasedScopeDefinition scopeDef, IEnvironment env) {
        this.scope = scopeDef;
        this.environment = env;
    }

    protected T getBodyForMethod(@NonNull SootMethod method) {
        T _result = null;
        if (this.isInScope(method)) {
            JimpleBody _body = (JimpleBody)method.retrieveActiveBody();
            _result = this.getStmtGraphForBody(_body);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Method " + method + " is out of scope or is not concrete.");
        }
        return _result;
    }

    @NonNull
    protected abstract T getStmtGraphForBody(@NonNull JimpleBody var1);

    @Functional
    protected final boolean isInScope(@NonNull SootMethod method) {
        return (this.scope == null || this.scope.isInScope(method, this.environment)) && method.isConcrete();
    }
}

