/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.scoping;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.scoping.ScopeExtensionEnum;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.RefType;
import soot.SootClass;
import soot.Type;

public final class TypeSpecification {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeSpecification.class);
    @NonNull
    private String namePattern;
    private Pattern nameRegex;
    private ScopeExtensionEnum scopeExtension;
    public static final String JiBX_bindingList = "|edu.ksu.cis.indus.common.scoping.JiBX_scoping_JiBXBindingFactory|";

    @Empty
    public TypeSpecification() {
    }

    @Functional
    public boolean conformant(@NonNull Type type, @NonNull IEnvironment system) {
        boolean _result;
        String _name = type.toString();
        if (this.scopeExtension.equals((Object)ScopeExtensionEnum.IDENTITY)) {
            _result = this.nameRegex.matcher(_name).matches();
        } else if (this.scopeExtension.equals((Object)ScopeExtensionEnum.PRIMITIVE)) {
            _result = this.namePattern.equals(_name);
        } else {
            SootClass _sc = ((RefType)type).getSootClass();
            SootClass _basisClass = system.getClass(this.namePattern);
            if (this.scopeExtension.equals((Object)ScopeExtensionEnum.EXCLUSIVE_ANCESTORS)) {
                _result = Util.isDescendentOf(_basisClass, _sc) && !_sc.equals(_basisClass);
            } else if (this.scopeExtension.equals((Object)ScopeExtensionEnum.EXCLUSIVE_DESCENDANTS)) {
                _result = Util.isDescendentOf(_sc, _basisClass) && !_sc.equals(_basisClass);
            } else if (this.scopeExtension.equals((Object)ScopeExtensionEnum.INCLUSIVE_ANCESTORS)) {
                _result = Util.isDescendentOf(_basisClass, _sc);
            } else if (this.scopeExtension.equals((Object)ScopeExtensionEnum.INCLUSIVE_DESCENDANTS)) {
                _result = Util.isDescendentOf(_sc, _basisClass);
            } else {
                String _msg = "Invalid scope extension [" + (Object)((Object)this.scopeExtension) + "] for reference type " + _name;
                LOGGER.error(_msg);
                throw new IllegalStateException(_msg);
            }
        }
        return _result;
    }

    @NonNull
    @Functional
    public String getNamePattern() {
        return this.namePattern;
    }

    @NonNull
    @Functional
    public ScopeExtensionEnum getScopeExtension() {
        return this.scopeExtension;
    }

    public void setNamePattern(@NonNull @Immutable String spec) {
        this.namePattern = spec;
        if (this.scopeExtension != null && this.scopeExtension.equals((Object)ScopeExtensionEnum.IDENTITY)) {
            this.nameRegex = Pattern.compile(spec);
        }
    }

    public void setScopeExtension(@NonNull @Immutable ScopeExtensionEnum theScopeExtension) {
        this.scopeExtension = theScopeExtension;
        if (this.scopeExtension.equals((Object)ScopeExtensionEnum.IDENTITY) && this.namePattern != null) {
            this.nameRegex = Pattern.compile(this.namePattern);
        }
    }

    @Functional
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("namePattern", (Object)this.namePattern).append("nameRegex", (Object)this.nameRegex).append("scopeExtension", (Object)this.scopeExtension).toString();
    }

    public static /* synthetic */ TypeSpecification JiBX_scoping_JiBXBinding_newinstance_1_0(UnmarshallingContext arg1) throws JiBXException {
        return new TypeSpecification();
    }

    public final /* synthetic */ TypeSpecification JiBX_scoping_JiBXBinding_unmarshalAttr_1_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        TypeSpecification typeSpecification = this;
        this.setScopeExtension(ScopeExtensionEnum.valueOf(arg1.attributeText("http://indus.projects.cis.ksu.edu/indus", "scopeExtension")));
        this.setNamePattern(arg1.attributeText("http://indus.projects.cis.ksu.edu/indus", "nameSpec"));
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ void JiBX_scoping_JiBXBinding_marshalAttr_1_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.attribute(3, "scopeExtension", this.getScopeExtension().toString()).attribute(3, "nameSpec", this.getNamePattern());
        arg1.popObject();
    }
}

