/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.scoping;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.scoping.ClassSpecification;
import edu.ksu.cis.indus.common.scoping.FieldSpecification;
import edu.ksu.cis.indus.common.scoping.ISpecification;
import edu.ksu.cis.indus.common.scoping.JiBX_MungeAdapter;
import edu.ksu.cis.indus.common.scoping.MethodSpecification;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpecificationBasedScopeDefinition
implements IUnmarshallable,
IMarshallable {
    private static final int INDENT = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecificationBasedScopeDefinition.class);
    @NonNull
    @NonNullContainer
    private Collection<ClassSpecification> classSpecs;
    @NonNull
    @NonNullContainer
    private Collection<FieldSpecification> fieldSpecs;
    @NonNull
    @NonNullContainer
    private Collection<MethodSpecification> methodSpecs;
    @NonNull
    @NonNullContainer
    private String name;
    public static final String JiBX_bindingList = "|edu.ksu.cis.indus.common.scoping.JiBX_scoping_JiBXBindingFactory|";

    @Empty
    public SpecificationBasedScopeDefinition() {
    }

    public static SpecificationBasedScopeDefinition deserialize(@NonNull String contents) throws JiBXException {
        SpecificationBasedScopeDefinition _result;
        IUnmarshallingContext _unmarshallingContext;
        try {
            IBindingFactory _bindingFactory = BindingDirectory.getFactory(SpecificationBasedScopeDefinition.class);
            _unmarshallingContext = _bindingFactory.createUnmarshallingContext();
        }
        catch (JiBXException _e) {
            LOGGER.error("Error while setting up JiBX.  Aborting.", (Throwable)_e);
            throw _e;
        }
        try {
            StringReader _reader = new StringReader(contents);
            _result = (SpecificationBasedScopeDefinition)_unmarshallingContext.unmarshalDocument((Reader)_reader, null);
        }
        catch (JiBXException _e) {
            LOGGER.error("Error while deserializing scope specification.", (Throwable)_e);
            throw _e;
        }
        return _result;
    }

    public static String serialize(@NonNull SpecificationBasedScopeDefinition scopeDef) throws JiBXException {
        String _result;
        IMarshallingContext _marshallingContext;
        try {
            IBindingFactory _bindingFactory = BindingDirectory.getFactory(SpecificationBasedScopeDefinition.class);
            _marshallingContext = _bindingFactory.createMarshallingContext();
            _marshallingContext.setIndent(4);
        }
        catch (JiBXException _e) {
            LOGGER.error("Error while setting up JiBX.", (Throwable)_e);
            throw _e;
        }
        try {
            StringWriter _writer = new StringWriter();
            _marshallingContext.marshalDocument((Object)scopeDef, "UTF-8", Boolean.TRUE, (Writer)_writer);
            _writer.flush();
            _result = _writer.toString();
        }
        catch (JiBXException _e) {
            LOGGER.error("Error while marshalling scope specification.", (Throwable)_e);
            throw _e;
        }
        return _result;
    }

    @NonNull
    public static <T extends ISpecification> Collection<T> createSpecContainer() {
        return new ArrayList();
    }

    @Functional
    @NonNull
    public Collection<ClassSpecification> getClassSpecs() {
        return this.classSpecs;
    }

    @Functional
    @NonNull
    public Collection<FieldSpecification> getFieldSpecs() {
        return this.fieldSpecs;
    }

    @Functional
    @NonNull
    public Collection<MethodSpecification> getMethodSpecs() {
        return this.methodSpecs;
    }

    @Functional
    @NonNull
    public String getName() {
        return this.name;
    }

    @Functional
    public boolean isInScope(@NonNull SootClass clazz, @NonNull IEnvironment system) {
        Iterator<ClassSpecification> _i = this.classSpecs.iterator();
        int _iEnd = this.classSpecs.size();
        boolean _result = false;
        int _iIndex = 0;
        while (_iIndex < _iEnd && !_result) {
            ClassSpecification _cs = _i.next();
            _result |= _cs.isInScope(clazz, system);
            ++_iIndex;
        }
        return _result;
    }

    @Functional
    public boolean isInScope(@NonNull SootField field, @NonNull IEnvironment system) {
        Iterator<FieldSpecification> _i = this.fieldSpecs.iterator();
        int _iEnd = this.fieldSpecs.size();
        boolean _result = !this.classSpecs.isEmpty() ? this.isInScope(field.getDeclaringClass(), system) : false;
        int _iIndex = 0;
        while (_iIndex < _iEnd && !_result) {
            FieldSpecification _fs = _i.next();
            _result |= _fs.isInScope(field, system);
            ++_iIndex;
        }
        return _result;
    }

    @Functional
    public boolean isInScope(@NonNull SootMethod method, @NonNull IEnvironment system) {
        Iterator<MethodSpecification> _i = this.methodSpecs.iterator();
        int _iEnd = this.methodSpecs.size();
        boolean _result = !this.classSpecs.isEmpty() ? this.isInScope(method.getDeclaringClass(), system) : false;
        int _iIndex = 0;
        while (_iIndex < _iEnd && !_result) {
            MethodSpecification _ms = _i.next();
            _result |= _ms.isInScope(method, system);
            ++_iIndex;
        }
        return _result;
    }

    public void setClassSpecs(@NonNull Collection<ClassSpecification> theClassSpecs) {
        this.classSpecs = theClassSpecs;
    }

    public void setFieldSpecs(@NonNull Collection<FieldSpecification> theFieldSpecs) {
        this.fieldSpecs = theFieldSpecs;
    }

    public void setMethodSpecs(@NonNull Collection<MethodSpecification> theMethodSpecs) {
        this.methodSpecs = theMethodSpecs;
    }

    public void setName(@NonNull String nameOfTheSpec) {
        this.name = nameOfTheSpec;
    }

    void reset() {
        this.classSpecs.clear();
        this.methodSpecs.clear();
        this.fieldSpecs.clear();
    }

    public static /* synthetic */ SpecificationBasedScopeDefinition JiBX_scoping_JiBXBinding_newinstance_1_0(UnmarshallingContext arg1) throws JiBXException {
        return new SpecificationBasedScopeDefinition();
    }

    public final /* synthetic */ SpecificationBasedScopeDefinition JiBX_scoping_JiBXBinding_unmarshalAttr_1_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        SpecificationBasedScopeDefinition specificationBasedScopeDefinition = this;
        this.setName(arg1.attributeText("http://indus.projects.cis.ksu.edu/indus", "specName"));
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ SpecificationBasedScopeDefinition JiBX_scoping_JiBXBinding_unmarshal_1_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        SpecificationBasedScopeDefinition specificationBasedScopeDefinition = this;
        Collection collection = this.getClassSpecs();
        if (collection == null) {
            collection = JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_newinstance_1_0(arg1);
        }
        this.setClassSpecs(JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_unmarshal_1_0(collection, arg1));
        Collection collection2 = this.getMethodSpecs();
        if (collection2 == null) {
            collection2 = JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_newinstance_1_0(arg1);
        }
        this.setMethodSpecs(JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_unmarshal_1_1(collection2, arg1));
        Collection collection3 = this.getFieldSpecs();
        if (collection3 == null) {
            collection3 = JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_newinstance_1_0(arg1);
        }
        this.setFieldSpecs(JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_unmarshal_1_2(collection3, arg1));
        arg1.popObject();
        return this;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(0).unmarshal((Object)this, arg1);
    }

    public final /* synthetic */ void JiBX_scoping_JiBXBinding_marshalAttr_1_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.attribute(3, "specName", this.getName());
        arg1.popObject();
    }

    public final /* synthetic */ void JiBX_scoping_JiBXBinding_marshal_1_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_marshal_1_2(this.getClassSpecs(), arg1);
        JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_marshal_1_3(this.getMethodSpecs(), arg1);
        JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_marshal_1_4(this.getFieldSpecs(), arg1);
        arg1.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(0, "edu.ksu.cis.indus.common.scoping.SpecificationBasedScopeDefinition").marshal((Object)this, arg1);
    }

    public /* synthetic */ int JiBX_getIndex() {
        return 0;
    }
}

