/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.scoping;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.scoping.AbstractSpecification;
import edu.ksu.cis.indus.common.scoping.AccessSpecifierWrapper;
import edu.ksu.cis.indus.common.scoping.TypeSpecification;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootField;
import soot.Type;

public final class FieldSpecification
extends AbstractSpecification
implements IUnmarshallable,
IMarshallable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldSpecification.class);
    @NonNull
    private TypeSpecification declaringClassSpec;
    @NonNull
    private TypeSpecification fieldTypeSpec;
    @NonNull
    private Pattern namePattern;
    public static final String JiBX_bindingList = "|edu.ksu.cis.indus.common.scoping.JiBX_scoping_JiBXBindingFactory|";

    @Empty
    public FieldSpecification() {
    }

    @NonNull
    @Functional
    public TypeSpecification getDeclaringClassSpec() {
        return this.declaringClassSpec;
    }

    @NonNull
    @Functional
    public String getFieldNameSpec() {
        return this.namePattern.pattern();
    }

    @NonNull
    @Functional
    public TypeSpecification getFieldTypeSpec() {
        return this.fieldTypeSpec;
    }

    @Functional
    public boolean isInScope(@NonNull SootField field, @NonNull IEnvironment system) {
        boolean _result = this.accessConformant(new AccessSpecifierWrapper(field));
        _result = _result && this.fieldTypeSpec.conformant(field.getType(), system);
        _result = _result && this.declaringClassSpec.conformant((Type)field.getDeclaringClass().getType(), system);
        boolean bl = _result = _result && this.namePattern.matcher(field.getName()).matches();
        if (!this.isInclusion()) {
            boolean bl2 = _result = !_result;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this + " " + field + " " + _result);
        }
        return _result;
    }

    public void setDeclaringClassSpec(@NonNull @Immutable TypeSpecification spec) {
        this.declaringClassSpec = spec;
    }

    public void setFieldNameSpec(@NonNull @Immutable String spec) {
        this.namePattern = Pattern.compile(spec);
    }

    public void setFieldTypeSpec(@NonNull @Immutable TypeSpecification spec) {
        this.fieldTypeSpec = spec;
    }

    @Functional
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("namePattern", (Object)this.namePattern.pattern()).append("fieldTypeSpec", (Object)this.fieldTypeSpec).append("declaringClassSpec", (Object)this.declaringClassSpec).toString();
    }

    public static /* synthetic */ FieldSpecification JiBX_scoping_JiBXBinding_newinstance_2_0(UnmarshallingContext arg1) throws JiBXException {
        return new FieldSpecification();
    }

    public final /* synthetic */ FieldSpecification JiBX_scoping_JiBXBinding_unmarshalAttr_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        FieldSpecification fieldSpecification = this;
        AbstractSpecification abstractSpecification = this.JiBX_scoping_JiBXBinding_unmarshalAttr_1_1(arg1);
        this.setFieldNameSpec(arg1.attributeText("http://indus.projects.cis.ksu.edu/indus", "fieldNameSpec"));
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ FieldSpecification JiBX_scoping_JiBXBinding_unmarshal_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        FieldSpecification fieldSpecification = this;
        this.JiBX_scoping_JiBXBinding_unmarshal_1_1(arg1);
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/indus", "declaringClassSpec");
        TypeSpecification typeSpecification = this.getDeclaringClassSpec();
        if (typeSpecification == null) {
            typeSpecification = TypeSpecification.JiBX_scoping_JiBXBinding_newinstance_1_0(arg1);
        }
        this.setDeclaringClassSpec(typeSpecification.JiBX_scoping_JiBXBinding_unmarshalAttr_1_0(arg1));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/indus", "declaringClassSpec");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/indus", "declaringClassSpec");
        arg1.parseToStartTag("http://indus.projects.cis.ksu.edu/indus", "fieldTypeSpec");
        TypeSpecification typeSpecification2 = this.getFieldTypeSpec();
        if (typeSpecification2 == null) {
            typeSpecification2 = TypeSpecification.JiBX_scoping_JiBXBinding_newinstance_1_0(arg1);
        }
        this.setFieldTypeSpec(typeSpecification2.JiBX_scoping_JiBXBinding_unmarshalAttr_1_0(arg1));
        arg1.parsePastStartTag("http://indus.projects.cis.ksu.edu/indus", "fieldTypeSpec");
        arg1.parsePastCurrentEndTag("http://indus.projects.cis.ksu.edu/indus", "fieldTypeSpec");
        arg1.popObject();
        return this;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(4).unmarshal((Object)this, arg1);
    }

    public final /* synthetic */ void JiBX_scoping_JiBXBinding_marshalAttr_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        this.JiBX_scoping_JiBXBinding_marshalAttr_1_1(arg1);
        MarshallingContext marshallingContext = arg1.attribute(3, "fieldNameSpec", this.getFieldNameSpec());
        arg1.popObject();
    }

    public final /* synthetic */ void JiBX_scoping_JiBXBinding_marshal_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        this.JiBX_scoping_JiBXBinding_marshal_1_1(arg1);
        arg1.startTagNamespaces(3, "declaringClassSpec", new int[]{3}, new String[]{"indus"});
        this.getDeclaringClassSpec().JiBX_scoping_JiBXBinding_marshalAttr_1_0(arg1);
        arg1.closeStartEmpty();
        arg1.startTagNamespaces(3, "fieldTypeSpec", new int[]{3}, new String[]{"indus"});
        this.getFieldTypeSpec().JiBX_scoping_JiBXBinding_marshalAttr_1_0(arg1);
        arg1.closeStartEmpty();
        arg1.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(4, "edu.ksu.cis.indus.common.scoping.FieldSpecification").marshal((Object)this, arg1);
    }

    public /* synthetic */ int JiBX_getIndex() {
        return 4;
    }
}

