/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.scoping;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.scoping.IAccessSpecifiers;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;

final class AccessSpecifierWrapper
implements IAccessSpecifiers {
    private SootClass clazz;
    private SootField field;
    private SootMethod method;

    public AccessSpecifierWrapper(@NonNull SootClass theClazz) {
        this.clazz = theClazz;
    }

    public AccessSpecifierWrapper(@NonNull SootField theField) {
        this.field = theField;
    }

    public AccessSpecifierWrapper(@NonNull SootMethod theMethod) {
        this.method = theMethod;
    }

    public boolean isDefaultAccess() {
        boolean _result = false;
        if (this.clazz != null) {
            _result = !this.clazz.isPrivate() && !this.clazz.isProtected() && !this.clazz.isPublic();
        } else if (this.method != null) {
            _result = !this.method.isPrivate() && !this.method.isProtected() && !this.method.isPublic();
        } else if (this.field != null) {
            _result = !this.field.isPrivate() && !this.field.isProtected() && !this.field.isPublic();
        }
        return _result;
    }

    public boolean isPrivateAccess() {
        boolean _result = false;
        if (this.clazz != null) {
            _result = this.clazz.isPrivate();
        } else if (this.method != null) {
            _result = this.method.isPrivate();
        } else if (this.field != null) {
            _result = this.field.isPrivate();
        }
        return _result;
    }

    public boolean isProtectedAccess() {
        boolean _result = false;
        if (this.clazz != null) {
            _result = this.clazz.isProtected();
        } else if (this.method != null) {
            _result = this.method.isProtected();
        } else if (this.field != null) {
            _result = this.field.isProtected();
        }
        return _result;
    }

    public boolean isPublicAccess() {
        boolean _result = false;
        if (this.clazz != null) {
            _result = this.clazz.isPublic();
        } else if (this.method != null) {
            _result = this.method.isPublic();
        } else if (this.field != null) {
            _result = this.field.isPublic();
        }
        return _result;
    }

    @Empty
    public void setDefaultAccess(boolean value) {
    }

    @Empty
    public void setPrivateAccess(boolean value) {
    }

    @Empty
    public void setProtectedAccess(boolean value) {
    }

    @Empty
    public void setPublicAccess(boolean value) {
    }
}

