/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.scoping;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.scoping.AccessSpecificationEnum;
import edu.ksu.cis.indus.common.scoping.IAccessSpecifiers;
import edu.ksu.cis.indus.common.scoping.JiBX_MungeAdapter;
import java.util.EnumSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public final class AccessSpecification {
    private final EnumSet<AccessSpecificationEnum> access = EnumSet.noneOf(AccessSpecificationEnum.class);

    public AccessSpecification() {
        this.access.add(AccessSpecificationEnum.PROTECTED_ACCESS);
        this.access.add(AccessSpecificationEnum.PUBLIC_ACCESS);
    }

    public boolean conformant(@NonNull IAccessSpecifiers specifier) {
        return this.isDefaultAccess() == specifier.isDefaultAccess() || this.isProtectedAccess() == specifier.isProtectedAccess() || this.isPublicAccess() == specifier.isPublicAccess() || this.isPrivateAccess() == specifier.isPrivateAccess();
    }

    public boolean isDefaultAccess() {
        return this.access.contains((Object)AccessSpecificationEnum.DEFAULT_ACCESS);
    }

    public boolean isPrivateAccess() {
        return this.access.contains((Object)AccessSpecificationEnum.PRIVATE_ACCESS);
    }

    public boolean isProtectedAccess() {
        return this.access.contains((Object)AccessSpecificationEnum.PROTECTED_ACCESS);
    }

    public boolean isPublicAccess() {
        return this.access.contains((Object)AccessSpecificationEnum.PUBLIC_ACCESS);
    }

    public void setDefaultAccess(boolean value) {
        if (value) {
            this.access.add(AccessSpecificationEnum.DEFAULT_ACCESS);
        } else {
            this.access.remove((Object)AccessSpecificationEnum.DEFAULT_ACCESS);
        }
    }

    public void setPrivateAccess(boolean value) {
        if (value) {
            this.access.add(AccessSpecificationEnum.PRIVATE_ACCESS);
        } else {
            this.access.remove((Object)AccessSpecificationEnum.PRIVATE_ACCESS);
        }
    }

    public void setProtectedAccess(boolean value) {
        if (value) {
            this.access.add(AccessSpecificationEnum.PROTECTED_ACCESS);
        } else {
            this.access.remove((Object)AccessSpecificationEnum.PROTECTED_ACCESS);
        }
    }

    public void setPublicAccess(boolean value) {
        if (value) {
            this.access.add(AccessSpecificationEnum.PUBLIC_ACCESS);
        } else {
            this.access.remove((Object)AccessSpecificationEnum.PUBLIC_ACCESS);
        }
    }

    @NonNull
    @Functional
    public String toString() {
        StringBuffer _access = new StringBuffer(this.access + " ");
        if (this.isPrivateAccess()) {
            _access.append("Private | ");
        }
        if (this.isDefaultAccess()) {
            _access.append("Package Private | ");
        }
        if (this.isProtectedAccess()) {
            _access.append("Protected | ");
        }
        if (this.isPublicAccess()) {
            _access.append("Public | ");
        }
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("access", (Object)_access).toString();
    }

    public static /* synthetic */ AccessSpecification JiBX_scoping_JiBXBinding_newinstance_1_0(UnmarshallingContext arg1) throws JiBXException {
        return new AccessSpecification();
    }

    public final /* synthetic */ AccessSpecification JiBX_scoping_JiBXBinding_unmarshal_1_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        AccessSpecification accessSpecification = this;
        EnumSet enumSet = this.access;
        if (enumSet == null) {
            enumSet = JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_newinstance_1_4(arg1);
        }
        this.access = JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_unmarshal_1_4(enumSet, arg1);
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ void JiBX_scoping_JiBXBinding_marshal_1_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        JiBX_MungeAdapter.JiBX_scoping_JiBXBinding_marshal_1_5(this.access, arg1);
        arg1.popObject();
    }
}

