/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.common.graph.AbstractDirectedGraphTest;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.SimpleNode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SimpleNodeGraphTest
extends AbstractDirectedGraphTest {
    protected final Map<String, SimpleNode<String>> name2node = new HashMap<String, SimpleNode<String>>();
    protected SimpleNodeGraph<String> sng;
    protected int numberOfCycles;

    public final void testGetNode() {
        for (Map.Entry<String, SimpleNode<String>> _entry : this.name2node.entrySet()) {
            SimpleNode<String> _node = this.sng.getNode(_entry.getKey());
            SimpleNodeGraphTest.assertTrue((boolean)_node.equals(_entry.getValue()));
            SimpleNodeGraphTest.assertTrue((boolean)_node.getObject().equals(_entry.getKey()));
        }
        try {
            this.sng.getNode(null);
        }
        catch (NullPointerException nullPointerException) {
            SimpleNodeGraphTest.fail((String)"Shouldn't have raised an exception.");
        }
    }

    public void testGetNodes() {
        List _nodes1 = this.dg.getNodes();
        SimpleNodeGraphTest.assertTrue((boolean)this.name2node.values().containsAll(this.dg.getNodes()));
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.getNodes().containsAll(this.name2node.values()));
        List _nodes2 = this.dg.getNodes();
        SimpleNodeGraphTest.assertTrue((boolean)_nodes1.equals(_nodes2));
    }

    public void testGetNodesInPathBetween() {
        HashSet<SimpleNode<String>> _t = new HashSet<SimpleNode<String>>();
        _t.add(this.sng.getNode("b"));
        _t.add(this.sng.getNode("e"));
        Collection _nodes = this.dg.getNodesOnPathBetween(_t);
        _t.add(this.sng.getNode("a"));
        SimpleNodeGraphTest.assertTrue((String)(_nodes + " " + _t), (_nodes.containsAll(_t) && _t.containsAll(_nodes) ? 1 : 0) != 0);
    }

    public void testGetTails() {
        Collection _dtails = this.dg.getTails();
        SimpleNodeGraphTest.assertTrue((_dtails.size() == 1 ? 1 : 0) != 0);
        SimpleNodeGraphTest.assertTrue((boolean)_dtails.contains(this.name2node.get("h")));
    }

    public void testlocalGetSinks() {
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.getSinks().isEmpty());
    }

    protected void setSNG(SimpleNodeGraph graph) {
        this.sng = graph;
        this.dg = this.sng;
    }

    protected void setUp() throws Exception {
        SimpleNodeGraph<String> _sng = new SimpleNodeGraph<String>();
        this.name2node.put("a", _sng.getNode("a"));
        this.name2node.put("b", _sng.getNode("b"));
        this.name2node.put("c", _sng.getNode("c"));
        this.name2node.put("d", _sng.getNode("d"));
        this.name2node.put("e", _sng.getNode("e"));
        this.name2node.put("f", _sng.getNode("f"));
        this.name2node.put("g", _sng.getNode("g"));
        this.name2node.put("h", _sng.getNode("h"));
        _sng.addEdgeFromTo(this.name2node.get("a"), this.name2node.get("b"));
        _sng.addEdgeFromTo(this.name2node.get("b"), this.name2node.get("c"));
        _sng.addEdgeFromTo(this.name2node.get("b"), this.name2node.get("f"));
        _sng.addEdgeFromTo(this.name2node.get("b"), this.name2node.get("e"));
        _sng.addEdgeFromTo(this.name2node.get("c"), this.name2node.get("d"));
        _sng.addEdgeFromTo(this.name2node.get("c"), this.name2node.get("g"));
        _sng.addEdgeFromTo(this.name2node.get("d"), this.name2node.get("c"));
        _sng.addEdgeFromTo(this.name2node.get("d"), this.name2node.get("h"));
        _sng.addEdgeFromTo(this.name2node.get("e"), this.name2node.get("f"));
        _sng.addEdgeFromTo(this.name2node.get("e"), this.name2node.get("a"));
        _sng.addEdgeFromTo(this.name2node.get("f"), this.name2node.get("g"));
        _sng.addEdgeFromTo(this.name2node.get("g"), this.name2node.get("h"));
        _sng.addEdgeFromTo(this.name2node.get("g"), this.name2node.get("f"));
        _sng.addEdgeFromTo(this.name2node.get("h"), this.name2node.get("h"));
        this.setSNG(_sng);
        this.numberOfCycles = 4;
    }

    protected void localtestAddEdgeFromTo() {
        HashMap _preds1 = new HashMap();
        HashMap _succs1 = new HashMap();
        this.extractPredSuccCopy(this.dg, _preds1, _succs1);
        this.sng.addEdgeFromTo(this.name2node.get("c"), this.name2node.get("h"));
        SimpleNodeGraphTest.assertTrue((boolean)this.name2node.get("c").getSuccsOf().contains(this.name2node.get("h")));
        SimpleNodeGraphTest.assertTrue((boolean)this.name2node.get("h").getPredsOf().contains(this.name2node.get("c")));
        HashMap _preds2 = new HashMap();
        HashMap _succs2 = new HashMap();
        this.extractPredSuccCopy(this.dg, _preds2, _succs2);
        for (INode _node : this.dg.getNodes()) {
            if (this.name2node.get("h") != _node) {
                SimpleNodeGraphTest.assertTrue((boolean)_preds1.get(_node).equals(_preds2.get(_node)));
            }
            if (this.name2node.get("c") == _node) continue;
            SimpleNodeGraphTest.assertTrue((boolean)_succs1.get(_node).equals(_succs2.get(_node)));
        }
        this.sng.addEdgeFromTo(this.name2node.get("a"), this.name2node.get("f"));
        _preds1.clear();
        _succs1.clear();
        this.extractPredSuccCopy(this.dg, _preds1, _succs1);
        SimpleNodeGraphTest.assertTrue((boolean)this.name2node.get("a").getSuccsOf().contains(this.name2node.get("f")));
        SimpleNodeGraphTest.assertTrue((boolean)this.name2node.get("f").getPredsOf().contains(this.name2node.get("a")));
        for (INode _node : this.dg.getNodes()) {
            if (this.name2node.get("f") != _node) {
                SimpleNodeGraphTest.assertTrue((boolean)_preds1.get(_node).equals(_preds2.get(_node)));
            }
            if (this.name2node.get("a") == _node) continue;
            SimpleNodeGraphTest.assertTrue((boolean)_succs1.get(_node).equals(_succs2.get(_node)));
        }
        try {
            SimpleNodeGraphTest.assertFalse((boolean)this.sng.addEdgeFromTo(new SimpleNode<String>("t1"), new SimpleNode<String>("t2")));
            SimpleNodeGraphTest.fail((String)"This should not happen!");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        HashMap _temp = new HashMap(this.dg.getSpanningSuccs());
        SimpleNodeGraphTest.assertTrue((boolean)this.sng.addEdgeFromTo(this.sng.getNode("i"), this.sng.getNode("b")));
        SimpleNodeGraphTest.assertFalse((boolean)_temp.equals(this.dg.getSpanningSuccs()));
    }

    protected void localtestGetCycles() {
        Collection _cycles = this.dg.getCycles();
        SimpleNodeGraphTest.assertTrue((String)(String.valueOf(_cycles.size()) + "==" + this.numberOfCycles), (_cycles.size() == this.numberOfCycles ? 1 : 0) != 0);
    }

    protected void localtestGetSCCs() {
        Collection _sccsTrue = this.dg.getSCCs(true);
        Collection _sccsFalse = this.dg.getSCCs(false);
        SimpleNodeGraphTest.assertFalse((boolean)_sccsTrue.isEmpty());
        SimpleNodeGraphTest.assertFalse((boolean)_sccsFalse.isEmpty());
    }

    protected void localtestIsAncestorOf() {
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isAncestorOf((INode)this.name2node.get("a"), (INode)this.name2node.get("a")));
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isAncestorOf((INode)this.name2node.get("h"), (INode)this.name2node.get("h")));
    }

    protected void localtestIsReachable() {
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isReachable((INode)this.name2node.get("a"), (INode)this.name2node.get("e"), true));
        SimpleNodeGraphTest.assertFalse((boolean)this.dg.isReachable((INode)this.name2node.get("f"), (INode)this.name2node.get("c"), true));
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isReachable((INode)this.name2node.get("h"), (INode)this.name2node.get("a"), false));
        SimpleNodeGraphTest.assertFalse((boolean)this.dg.isReachable((INode)this.name2node.get("c"), (INode)this.name2node.get("h"), false));
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isReachable((INode)this.name2node.get("h"), (INode)this.name2node.get("h"), false));
        SimpleNodeGraphTest.assertTrue((boolean)this.dg.isReachable((INode)this.name2node.get("h"), (INode)this.name2node.get("h"), true));
    }

    protected void tearDown() throws Exception {
        this.dg = null;
        this.sng = null;
        this.name2node.clear();
    }
}

