/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.common.graph.SimpleNode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraphTest;
import java.util.Collection;
import java.util.HashSet;

public class SimpleNodeGraphNoCycleTest
extends SimpleNodeGraphTest {
    public void testGetNodesInPathBetween() {
        HashSet<SimpleNode<String>> _t = new HashSet<SimpleNode<String>>();
        _t.add(this.sng.getNode("b"));
        _t.add(this.sng.getNode("d"));
        Collection _nodes = this.dg.getNodesOnPathBetween(_t);
        SimpleNodeGraphNoCycleTest.assertTrue((boolean)_nodes.containsAll(_t));
    }

    public void testGetTails() {
        SimpleNodeGraphNoCycleTest.assertFalse((boolean)this.dg.getTails().isEmpty());
    }

    public void testlocalGetSinks() {
        SimpleNodeGraphNoCycleTest.assertFalse((boolean)this.dg.getSinks().isEmpty());
    }

    public void testlocalGraphGetSinks() {
        SimpleNodeGraphNoCycleTest.assertFalse((boolean)this.sng.getSinks().isEmpty());
    }

    protected void setUp() throws Exception {
        SimpleNodeGraph<String> _sng = new SimpleNodeGraph<String>();
        this.name2node.put("a", _sng.getNode("a"));
        this.name2node.put("b", _sng.getNode("b"));
        this.name2node.put("c", _sng.getNode("c"));
        this.name2node.put("d", _sng.getNode("d"));
        this.name2node.put("e", _sng.getNode("e"));
        _sng.addEdgeFromTo((SimpleNode)this.name2node.get("a"), (SimpleNode)this.name2node.get("b"));
        _sng.addEdgeFromTo((SimpleNode)this.name2node.get("b"), (SimpleNode)this.name2node.get("c"));
        _sng.addEdgeFromTo((SimpleNode)this.name2node.get("b"), (SimpleNode)this.name2node.get("d"));
        _sng.addEdgeFromTo((SimpleNode)this.name2node.get("d"), (SimpleNode)this.name2node.get("e"));
        _sng.addEdgeFromTo((SimpleNode)this.name2node.get("e"), (SimpleNode)this.name2node.get("c"));
        this.setSNG(_sng);
    }

    @Empty
    protected final void localtestAddEdgeFromTo() {
    }

    protected void localtestGetCycles() {
        SimpleNodeGraphNoCycleTest.assertTrue((boolean)this.dg.getCycles().isEmpty());
    }

    protected final void tearDown() throws Exception {
        super.tearDown();
    }

    protected void localtestIsAncestorOf() {
        SimpleNodeGraphNoCycleTest.assertTrue((boolean)this.sng.isAncestorOf((SimpleNode)this.name2node.get("a"), (SimpleNode)this.name2node.get("a")));
        SimpleNodeGraphNoCycleTest.assertTrue((boolean)this.sng.isAncestorOf((SimpleNode)this.name2node.get("a"), (SimpleNode)this.name2node.get("e")));
        SimpleNodeGraphNoCycleTest.assertFalse((boolean)this.sng.isAncestorOf((SimpleNode)this.name2node.get("e"), (SimpleNode)this.name2node.get("b")));
    }

    protected void localtestIsReachable() {
        SimpleNodeGraphNoCycleTest.assertFalse((boolean)this.sng.isReachable((SimpleNode)this.name2node.get("a"), (SimpleNode)this.name2node.get("a"), true));
        SimpleNodeGraphNoCycleTest.assertTrue((boolean)this.sng.isReachable((SimpleNode)this.name2node.get("a"), (SimpleNode)this.name2node.get("e"), true));
        SimpleNodeGraphNoCycleTest.assertTrue((boolean)this.sng.isReachable((SimpleNode)this.name2node.get("e"), (SimpleNode)this.name2node.get("a"), false));
        SimpleNodeGraphNoCycleTest.assertTrue((boolean)this.sng.isReachable((SimpleNode)this.name2node.get("b"), (SimpleNode)this.name2node.get("e"), true));
        SimpleNodeGraphNoCycleTest.assertFalse((boolean)this.sng.isReachable((SimpleNode)this.name2node.get("d"), (SimpleNode)this.name2node.get("c"), false));
    }
}

