/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.graph.GraphInfo;
import edu.ksu.cis.indus.common.graph.IObjectNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectGraphInfo<N extends IObjectNode<N, O>, O>
extends GraphInfo<N> {
    @NonNull
    private final ITransformer<O, N> obj2nodeTransformer;
    @NonNull
    @NonNullContainer
    private final Map<O, N> object2nodes = new HashMap<O, N>();

    public ObjectGraphInfo(@NonNull @Immutable ITransformer<O, N> object2nodeTransformer) {
        this.obj2nodeTransformer = object2nodeTransformer;
    }

    @NonNull
    public N getNode(@Immutable O object) {
        Object _result = this.queryNode(object);
        if (_result == null) {
            _result = (IObjectNode)this.obj2nodeTransformer.transform(object);
            this.object2nodes.put(object, _result);
            this.addNode(_result);
        }
        return _result;
    }

    @Functional
    public N queryNode(@Immutable O o) {
        IObjectNode _result = (IObjectNode)this.object2nodes.get(o);
        return (N)_result;
    }

    @Override
    public boolean removeNode(@NonNull @Immutable N node) {
        Iterator<Map.Entry<O, N>> _i = this.object2nodes.entrySet().iterator();
        int _iEnd = this.object2nodes.entrySet().size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Map.Entry<O, N> _e = _i.next();
            if (_e.getValue() == node) {
                _i.remove();
                break;
            }
            ++_iIndex;
        }
        return super.removeNode(node);
    }
}

