/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.graph.INode;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node<T extends Node<T>>
implements INode<T> {
    @NonNull
    @NonNullContainer
    protected final Collection<T> predecessors;
    @NonNull
    @NonNullContainer
    protected final Collection<T> successors;

    public Node(@Immutable @NonNull @NonNullContainer Collection<T> preds, @Immutable @NonNull @NonNullContainer Collection<T> succs) {
        this.predecessors = preds;
        this.successors = succs;
    }

    @Override
    @NonNull
    @NonNullContainer
    @Functional
    public Collection<T> getPredsOf() {
        return Collections.unmodifiableCollection(this.predecessors);
    }

    @Override
    @NonNull
    @NonNullContainer
    @Functional
    public final Collection<T> getSuccsNodesInDirection(boolean forward) {
        Collection<T> _result = forward ? this.getSuccsOf() : this.getPredsOf();
        return _result;
    }

    @Override
    @NonNull
    @NonNullContainer
    @Functional
    public Collection<T> getSuccsOf() {
        return Collections.unmodifiableCollection(this.successors);
    }
}

