/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.graph.EdgeLabelledNode;
import edu.ksu.cis.indus.common.graph.IEdgeLabel;
import edu.ksu.cis.indus.common.graph.IEdgeLabelledDirectedGraph;
import edu.ksu.cis.indus.common.graph.IMutableEdgeLabelledNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableEdgeLabelledNode<T extends MutableEdgeLabelledNode<T>>
extends EdgeLabelledNode<T>
implements IMutableEdgeLabelledNode<T> {
    protected MutableEdgeLabelledNode(@Immutable @NonNull @NonNullContainer Collection<T> preds, @Immutable @NonNull @NonNullContainer Collection<T> succs) {
        super(preds, succs);
    }

    static <T1> boolean removedEdgesLabelled(@NonNull @Immutable IEdgeLabel label, @NonNull @NonNullContainer Map<IEdgeLabel, Collection<T1>> map, @NonNull @NonNullContainer Collection<T1> col) {
        boolean _result = map.remove(label) != null;
        MutableEdgeLabelledNode.retainAllIn(col, map.values());
        return _result;
    }

    static <T1> boolean removeNode(@NonNull @Immutable T1 node, @NonNull @NonNullContainer Map<IEdgeLabel, Collection<T1>> map, @NonNull @NonNullContainer Collection<T1> col) {
        Iterator<IEdgeLabel> _i = map.keySet().iterator();
        int _iEnd = map.keySet().size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            IEdgeLabel _k = _i.next();
            map.get(_k).remove(node);
            ++_iIndex;
        }
        return col.remove(node);
    }

    static <T1> void retainAllIn(@NonNull @NonNullContainer Collection<T1> col, @NonNull @NonNullContainer @Immutable Collection<Collection<T1>> collections) {
        for (Collection<T1> _c : collections) {
            col.retainAll(_c);
        }
    }

    @Override
    public final boolean addIncomingEdgeLabelledFrom(@NonNull @Immutable IEdgeLabel label, @NonNull @Immutable T node) {
        this.predecessors.add(node);
        return MapUtils.putIntoCollectionInMap(this.label2inNodes, label, node);
    }

    @Override
    public final boolean addOutgoingEdgeLabelledTo(@NonNull @Immutable IEdgeLabel label, @NonNull @Immutable T node) {
        this.successors.add(node);
        return MapUtils.putIntoCollectionInMap(this.label2outNodes, label, node);
    }

    @Override
    public final boolean addPredecessor(@NonNull @Immutable T node) {
        return this.addIncomingEdgeLabelledFrom(IEdgeLabelledDirectedGraph.DUMMY_LABEL, node);
    }

    @Override
    public final boolean addSuccessor(@NonNull @Immutable T node) {
        return this.addOutgoingEdgeLabelledTo(IEdgeLabelledDirectedGraph.DUMMY_LABEL, node);
    }

    @Override
    public final boolean removeIncomingEdgeLabelledFrom(@NonNull @Immutable IEdgeLabel label, @NonNull @Immutable T node) {
        return this.removeEdgesLabelledForViaUpdate(label, node, this.label2inNodes, this.predecessors);
    }

    @Override
    public final boolean removeIncomingEdgesLabelled(@NonNull @Immutable IEdgeLabel label) {
        return MutableEdgeLabelledNode.removedEdgesLabelled(label, this.label2inNodes, this.predecessors);
    }

    @Override
    public final boolean removeOutgoingEdgeLabelledTo(@NonNull @Immutable IEdgeLabel label, @Immutable @NonNull T node) {
        return this.removeEdgesLabelledForViaUpdate(label, node, this.label2outNodes, this.successors);
    }

    @Override
    public final boolean removeOutgoingEdgesLabelled(@Immutable @NonNull IEdgeLabel label) {
        return MutableEdgeLabelledNode.removedEdgesLabelled(label, this.label2outNodes, this.successors);
    }

    @Override
    public final boolean removePredecessor(@Immutable @NonNull T node) {
        return MutableEdgeLabelledNode.removeNode(node, this.label2inNodes, this.predecessors);
    }

    @Override
    public final boolean removeSuccessor(@NonNull @Immutable T node) {
        return MutableEdgeLabelledNode.removeNode(node, this.label2outNodes, this.successors);
    }

    boolean removeEdgesLabelledForViaUpdate(@NonNull @Immutable IEdgeLabel label, @NonNull @Immutable T node, @NonNull @NonNullContainer Map<IEdgeLabel, Collection<T>> map, @NonNull @NonNullContainer Collection<T> col) {
        boolean _result;
        Collection<T> _t = MapUtils.queryCollection(map, label);
        if (_t.isEmpty()) {
            _result = false;
        } else {
            _result = _t.remove(node);
            if (_result) {
                if (_t.isEmpty()) {
                    map.remove(label);
                }
                MutableEdgeLabelledNode.retainAllIn(col, map.values());
            }
        }
        return _result;
    }
}

