/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.graph.EdgeLabelledNode;
import edu.ksu.cis.indus.common.graph.GraphInfo;
import edu.ksu.cis.indus.common.graph.IEdgeLabel;
import edu.ksu.cis.indus.common.graph.IEdgeLabelledDirectedGraph;
import edu.ksu.cis.indus.common.graph.IMutableEdgeLabelledDirectedGraph;
import edu.ksu.cis.indus.common.graph.MutableDirectedGraph;
import edu.ksu.cis.indus.common.graph.MutableEdgeLabelledNode;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableEdgeLabelledDirectedGraph<N extends MutableEdgeLabelledNode<N>>
extends MutableDirectedGraph<N>
implements IMutableEdgeLabelledDirectedGraph<N> {
    protected MutableEdgeLabelledDirectedGraph(@NonNull @Immutable GraphInfo<N> info) {
        super(info);
    }

    @Override
    public final boolean addEdgeFromTo(@NonNull N src, @NonNull IEdgeLabel label, @NonNull N dest) {
        boolean _result = super.addEdgeFromTo(src, dest);
        if (_result) {
            ((MutableEdgeLabelledNode)src).addOutgoingEdgeLabelledTo(label, dest);
            ((MutableEdgeLabelledNode)dest).addIncomingEdgeLabelledFrom(label, src);
        }
        return _result;
    }

    @Override
    public final boolean addEdgeFromTo(@NonNull N src, @NonNull N dest) {
        return this.addEdgeFromTo(src, IEdgeLabelledDirectedGraph.DUMMY_LABEL, dest);
    }

    @Override
    public final boolean removeAllEdgesLabelled(@NonNull @Immutable IEdgeLabel label) {
        boolean _result = true;
        Iterator _i = this.getNodes().iterator();
        int _iEnd = this.getNodes().size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            MutableEdgeLabelledNode _node = (MutableEdgeLabelledNode)_i.next();
            _result &= _node.removeOutgoingEdgesLabelled(label);
            _result &= _node.removeIncomingEdgesLabelled(label);
            ++_iIndex;
        }
        return _result;
    }

    @Override
    public final boolean removeAllEdgesLabelledFrom(@NonNull @Immutable IEdgeLabel label, @NonNull N node) {
        Collection _dests = ((EdgeLabelledNode)node).getSuccsViaEdgesLabelled(label);
        Iterator _i = _dests.iterator();
        int _iEnd = _dests.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            MutableEdgeLabelledNode _dest = (MutableEdgeLabelledNode)_i.next();
            _dest.removeIncomingEdgeLabelledFrom(label, node);
            ++_iIndex;
        }
        return ((MutableEdgeLabelledNode)node).removeOutgoingEdgesLabelled(label);
    }

    @Override
    public final boolean removeAllEdgesLabelledTo(@NonNull @Immutable IEdgeLabel label, @NonNull N node) {
        Collection _srcs = ((EdgeLabelledNode)node).getPredsViaEdgesLabelled(label);
        Iterator _i = _srcs.iterator();
        int _iEnd = _srcs.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            MutableEdgeLabelledNode _src = (MutableEdgeLabelledNode)_i.next();
            _src.removeOutgoingEdgeLabelledTo(label, node);
            ++_iIndex;
        }
        return ((MutableEdgeLabelledNode)node).removeIncomingEdgesLabelled(label);
    }

    @Override
    public final boolean removeEdgeFromTo(@NonNull @Immutable N src, @NonNull @Immutable IEdgeLabel label, @Immutable @NonNull N dest) {
        return ((MutableEdgeLabelledNode)src).removeOutgoingEdgeLabelledTo(label, dest) && ((MutableEdgeLabelledNode)dest).removeIncomingEdgeLabelledFrom(label, src);
    }

    @Override
    public final boolean removeEdgeFromTo(@Immutable @NonNull N src, @Immutable @NonNull N dest) {
        return this.removeEdgeFromTo(src, IEdgeLabelledDirectedGraph.DUMMY_LABEL, dest);
    }
}

