/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.graph.AbstractDirectedGraph;
import edu.ksu.cis.indus.common.graph.GraphInfo;
import edu.ksu.cis.indus.common.graph.IMutableDirectedGraph;
import edu.ksu.cis.indus.common.graph.IMutableNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableDirectedGraph<N extends IMutableNode<N>>
extends AbstractDirectedGraph<N>
implements IMutableDirectedGraph<N> {
    @NonNull
    protected final GraphInfo<N> graphInfo;

    protected MutableDirectedGraph() {
        this.graphInfo = new GraphInfo();
    }

    protected MutableDirectedGraph(@NonNull @Immutable GraphInfo<N> info) {
        this.graphInfo = info;
    }

    @Override
    public boolean addEdgeFromTo(@NonNull N src, @NonNull N dest) {
        boolean _result = false;
        if (!this.containsNode(src) || !this.containsNode(dest)) {
            throw new IllegalArgumentException("Either or both of the provided nodes do not exist in this graph.");
        }
        src.addSuccessor(dest);
        dest.addPredecessor(src);
        this.shapeChanged();
        _result = true;
        return _result;
    }

    @Override
    public boolean addNode(@NonNull @Immutable N node) {
        return this.graphInfo.addNode(node);
    }

    @Override
    @NonNull
    @NonNullContainer
    public List<N> getNodes() {
        return this.graphInfo.getNodes();
    }

    @Override
    public boolean removeEdgeFromTo(@NonNull N src, @NonNull N dest) {
        boolean _result = false;
        if (!this.containsNode(src) || !this.containsNode(dest)) {
            throw new IllegalArgumentException("Either or both of the provided nodes do not exist in this graph.");
        }
        src.removeSuccessor(dest);
        dest.removePredecessor(src);
        this.shapeChanged();
        _result = true;
        return _result;
    }

    @Override
    public final boolean removeNode(@NonNull N node) {
        ArrayList _succsOf = new ArrayList(node.getSuccsOf());
        Iterator _i = _succsOf.iterator();
        int _iEnd = _succsOf.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            ((IMutableNode)_i.next()).removePredecessor(node);
            ++_iIndex;
        }
        ArrayList _predsOf = new ArrayList(node.getPredsOf());
        Iterator _j = _predsOf.iterator();
        int _jEnd = _predsOf.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            ((IMutableNode)_j.next()).removeSuccessor(node);
            ++_jIndex;
        }
        this.shapeChanged();
        return this.graphInfo.removeNode(node);
    }

    @Functional
    protected final boolean containsNode(@NonNull N node) {
        return this.getNodes().contains(node);
    }

    @Override
    protected final int getIndexOfNode(@NonNull @Immutable N node) {
        return this.graphInfo.getIndexOfNode(node);
    }

    @Override
    protected final void shapeChanged() {
        super.shapeChanged();
        this.graphInfo.shapeChanged();
    }
}

