/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.IObjectDirectedGraph;
import edu.ksu.cis.indus.common.graph.IObjectNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IDirectedGraph<N extends INode<N>> {
    @NonNull
    @NonNullContainer
    public Collection<Pair<N, N>> getBackEdges();

    @NonNull
    @NonNullContainer
    public Collection<N> getCommonReachablesFrom(@NonNull @Immutable N var1, boolean var2, @NonNull @Immutable N var3, boolean var4);

    @NonNull
    @NonNullContainer
    public Collection<N> getConnectivityNodesFor(@NonNull @Immutable N var1, @NonNull @Immutable N var2, boolean var3);

    @NonNull
    @NonNullContainer
    public Collection<List<N>> getCycles();

    @NonNull
    public IObjectDirectedGraph<? extends IObjectNode<?, N>, N> getDAG();

    @NonNull
    @NonNullContainer
    public List<N> getNodes();

    @NonNull
    @NonNullContainer
    public Collection<N> getNodesOnPathBetween(@NonNull @Immutable @NonNullContainer Collection<N> var1);

    @NonNull
    @NonNullContainer
    public Collection<N> getReachablesFrom(@NonNull @Immutable N var1, boolean var2);

    @NonNull
    @NonNullContainer
    public List<List<N>> getSCCs(boolean var1);

    @NonNull
    @NonNullContainer
    public Collection<N> getSinks();

    @NonNull
    @NonNullContainer
    public Collection<N> getSources();

    @NonNull
    @NonNullContainer
    public Map<N, Set<N>> getSpanningSuccs();

    @NonNull
    @NonNullContainer
    public Collection<N> getTails();

    public boolean hasCommonReachablesFrom(@NonNull @Immutable N var1, boolean var2, @NonNull @Immutable N var3, boolean var4);

    public boolean isAncestorOf(@NonNull @Immutable N var1, @NonNull @Immutable N var2);

    public boolean isReachable(@NonNull @Immutable N var1, @NonNull @Immutable N var2, boolean var3);

    @NonNull
    @NonNullContainer
    public List<N> performTopologicalSort(boolean var1);
}

